/**
 *  created: 03/02/2022, 14:00:33
**/

#include <bits/stdc++.h>

using namespace std;

const int max_n = 500555, inf = 1000111222;

mt19937 gen;

struct treap {
    int sz, value, prior;
    treap *left, *right, *parent;

    treap(int v) {
        value = v;
        sz = 1;
        prior = gen();
        left = NULL;
        right = NULL;
        parent = NULL;
    }
};

int get_size(treap *t) {
    if (t == NULL) {
        return 0;
    }
    return t->sz;
}

vector<pair<int*, int>> ops1;
vector<pair<treap**, treap*>> ops2;

void update(treap *&t) {
    if (t == NULL) {
        return;
    }
    ops1.push_back({&t->sz, t->sz});
    t->sz = 1 + get_size(t->left) + get_size(t->right);
    if (t->left) {
        ops2.push_back({&t->left->parent, t->left->parent});
        t->left->parent = t;
    }
    if (t->right) {
        ops2.push_back({&t->right->parent, t->right->parent});
        t->right->parent = t;
    }
}

treap *merge(treap *t1, treap *t2) {
    if (t1 == NULL) {
        return t2;
    }
    if (t2 == NULL) {
        return t1;
    }
    if (t1->prior <= t2->prior) {
        ops2.push_back({&t2->left, t2->left});
        t2->left = merge(t1, t2->left);
        update(t2);
        return t2;
    } else {
        ops2.push_back({&t1->right, t1->right});
        t1->right = merge(t1->right, t2);
        update(t1);
        return t1;
    }
}

void split(treap *our, int key, treap *&l, treap *&r) {
    if (our == NULL) {
        if (l) {
            ops2.push_back({&l, l});
        }
        if (r) {
            ops2.push_back({&r, r});
        }
        l = NULL;
        r = NULL;
        return;
    }
    if (our->value >= key) {
        if (r) {
            ops2.push_back({&r, r});
        }
        r = our;
        split(r->left, key, l, r->left);
    } else {
        if (l) {
            ops2.push_back({&l, l});
        }
        l = our;
        split(l->right, key, l->right, r);
    }
    update(l);
    update(r);
}

treap *unite(treap *t1, treap *t2) {
    if (t1 == NULL) {
        return t2;
    }
    if (t2 == NULL) {
        return t1;
    }
    if (t1->prior > t2->prior) {
        swap(t1, t2);
    }
    treap *buf1 = NULL, *buf2 = NULL;
    split(t2, t1->value, buf1, buf2);
    ops2.push_back({&t1->left, t1->left});
    ops2.push_back({&t1->right, t1->right});
    t1->left = unite(t1->left, buf1);
    t1->right = unite(t1->right, buf2);
    update(t1);
    return t1;
}

treap *get_root(treap *t) {
    while (t->parent) {
        t = t->parent;
    }
    return t;
}

int get_kth(treap *t, int k) {
    if (get_size(t->left) >= k) {
        return get_kth(t->left, k);
    }
    if (get_size(t->left) + 1 == k) {
        return t->value;
    }
    return get_kth(t->right, k - get_size(t->left) - 1);
}

int n, q, group, versions[max_n], ans[max_n];
treap *t[max_n];
vector<pair<int, pair<int, int>>> g[max_n], all[max_n];

void dfs(int version) {
    for (auto [id, q] : all[version]) {
        auto [v, k] = q;
        //cout << "#" << version << " " << id << " " << v << " " << k << endl;
        treap *root = get_root(t[v]);
        if (get_size(root) < k) {
            ans[id] = -1;
        } else {
            ans[id] = get_kth(root, k);
        }
    }
    const int sz1 = ops1.size();
    const int sz2 = ops2.size();
    for (auto [id, q] : g[version]) {
        auto [u, v] = q;
        treap *root1 = get_root(t[u]);
        treap *root2 = get_root(t[v]);
        if (root1 != root2) {
            unite(root1, root2);
        }
        //cout << version << " -> " << id << "   " << u << " " << v << endl;
        dfs(id);
        //cout << "restoring after " << version << " -> " << id << "   " << u << " " << v << endl;
        while (ops1.size() > sz1) {
            *ops1.back().first = ops1.back().second;
            ops1.pop_back();
            //cout << "-" << endl;
        }
        while (ops2.size() > sz2) {
            *ops2.back().first = ops2.back().second;
            ops2.pop_back();
            //cout << "--" << endl;
        }
        /*for (int i = 0; i < 3; ++i) {
            cout << get_root(t[i]) << " " << t[i] << "   " << t[i]->left << " " << t[i]->right << " " << t[i]->value << " " << t[i]->sz << endl;
        }*/
    }
}

int main() {
    //freopen("input.txt", "r", stdin);
    //freopen("output.txt", "w", stdout);
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cin >> n >> q >> group;
    int version = 0, first = 0, cnt_get = 0;
    for (int i = 1; i <= q; ++i) {
        int tp;
        cin >> tp;
        if (tp == 1) {
            versions[i] = version;
            int v, k;
            cin >> v >> k;
            --v;
            all[version].push_back({cnt_get++, {v, k}});
        } else if (tp == 2) {
            int u, v;
            cin >> u >> v;
            --u;
            --v;
            ++first;
            versions[i] = first;
            g[version].push_back({first, {u, v}});
        } else {
            int id;
            cin >> id;
            versions[i] = versions[id];
        }
        version = versions[i];
    }
    for (int i = 0; i < n; ++i) {
        t[i] = new treap(i + 1);
    }
    dfs(0);
    for (int i = 0; i < cnt_get; ++i) {
        cout << ans[i] << "\n";
    }
    return 0;
}