/**
 *  created: 03/02/2022, 14:00:33
**/

#include <bits/stdc++.h>
#include <ext/pb_ds/assoc_container.hpp>

using namespace std;
using namespace __gnu_pbds;

typedef tree<
int,
null_type,
less<int>,
rb_tree_tag,
tree_order_statistics_node_update> ordered_set;

const int max_n = 500555, inf = 1000111222;

struct dsu {
    int p_or_sz[max_n];
    ordered_set q[max_n];

    void init(int n) {
        for (int i = 0; i < n; ++i) {
            p_or_sz[i] = -1;
            q[i].insert(i + 1);
        }
    }

    int find_set(int v) const {
        if (p_or_sz[v] < 0) {
            return v;
        }
        return find_set(p_or_sz[v]);
    }

    bool union_set(int v1, int v2) {
        v1 = find_set(v1);
        v2 = find_set(v2);
        if (v1 == v2) {
            return false;
        }
        if (-p_or_sz[v1] > -p_or_sz[v2]) {
            swap(v1, v2);
        }
        ops.push_back({v1, v2});
        p_or_sz[v2] += p_or_sz[v1];
        p_or_sz[v1] = v2;
        for (int x : q[v1]) {
            q[v2].insert(x);
        }
        return true;
    }

    int get_size(int v) const {
        return -p_or_sz[find_set(v)];
    }

    int get_kth(int v, int k) const {
        return *q[find_set(v)].find_by_order(k - 1);
    }

    vector<pair<int, int>> ops;

    void restore(int sz) {
        while (ops.size() > sz) {
            auto [v1, v2] = ops.back();
            p_or_sz[v1] = -int(q[v1].size());
            p_or_sz[v2] -= p_or_sz[v1];
            for (int x : q[v1]) {
                q[v2].erase(x);
            }
            ops.pop_back();
        }
    }
};

int n, q, group, versions[max_n], ans[max_n], cnt_gets[max_n];
vector<pair<int, pair<int, int>>> g[max_n], all[max_n];
dsu d;

void calc_cnt_gets(int version) {
    cnt_gets[version] = all[version].size();
    for (auto [id, q] : g[version]) {
        calc_cnt_gets(id);
        cnt_gets[version] += cnt_gets[id];
    }
}

void dfs(int version, bool one_component) {
    for (auto [id, q] : all[version]) {
        auto [v, k] = q;
        if (one_component) {
            ans[id] = k;
            continue;
        }
        //cout << "#" << version << " " << id << " " << v << " " << k << endl;
        if (d.get_size(v) < k) {
            ans[id] = -1;
        } else {
            ans[id] = d.get_kth(v, k);
        }
        //cout << "#" << version << " " << id << " " << v << " " << k << endl;
    }
    const int sz = d.ops.size();
    for (auto [id, q] : g[version]) {
        if (!cnt_gets[id]) {
            continue;
        }
        if (one_component) {
            dfs(id, 1);
            continue;
        }
        auto [u, v] = q;
        int root1 = d.find_set(u), root2 = d.find_set(v);
        if (root1 != root2) {
            if (d.get_size(root1) + d.get_size(root2) == n) {
                dfs(id, 1);
                continue;
            }
            d.union_set(root1, root2);
        }
        //cout << version << " -> " << id << "   " << u << " " << v << endl;
        dfs(id, 0);
        //cout << "restoring after " << version << " -> " << id << "   " << u << " " << v << endl;
        d.restore(sz);
    }
}

int main() {
    //freopen("input.txt", "r", stdin);
    //freopen("output.txt", "w", stdout);
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cin >> n >> q >> group;
    int version = 0, first = 0, cnt_get = 0;
    for (int i = 1; i <= q; ++i) {
        int tp;
        cin >> tp;
        if (tp == 1) {
            versions[i] = version;
            int v, k;
            cin >> v >> k;
            --v;
            all[version].push_back({cnt_get++, {v, k}});
        } else if (tp == 2) {
            int u, v;
            cin >> u >> v;
            --u;
            --v;
            ++first;
            versions[i] = first;
            g[version].push_back({first, {u, v}});
        } else {
            int id;
            cin >> id;
            versions[i] = versions[id];
        }
        version = versions[i];
    }
    d.init(n);
    calc_cnt_gets(0);
    dfs(0, 0);
    for (int i = 0; i < cnt_get; ++i) {
        cout << ans[i] << "\n";
    }
    return 0;
}