/**
 *  created: 03/02/2022, 18:13:33
**/

#pragma GCC optimize("Ofast", "unroll-loops")
#pragma GCC target("sse,sse2,sse3,ssse3,sse4")

#include <bits/stdc++.h>

using namespace std;

const int max_n = 500555, inf = 1000111222;
const int magic = 8000;

int L, R;

struct dsu {
    int p_or_sz[max_n];
    unsigned int cnt_in_range[max_n];

    void init(int n) {
        for (int i = 0; i < n; ++i) {
            p_or_sz[i] = -1;
            cnt_in_range[i] = (L <= i && i < R);
        }
    }

    int find_set(int v) const {
        if (p_or_sz[v] < 0) {
            return v;
        }
        return find_set(p_or_sz[v]);
    }

    bool union_set(int v1, int v2) {
        v1 = find_set(v1);
        v2 = find_set(v2);
        if (v1 == v2) {
            return false;
        }
        if (-p_or_sz[v1] > -p_or_sz[v2]) {
            swap(v1, v2);
        }
        ops.push_back({v1, v2});
        p_or_sz[v2] += p_or_sz[v1];
        cnt_in_range[v2] += cnt_in_range[v1];
        cnt_in_range[v1] |= (-p_or_sz[v1]) << 13;
        p_or_sz[v1] = v2;
        return true;
    }

    int get_cnt(int v) const {
        return cnt_in_range[find_set(v)];
    }

    vector<pair<int, int>> ops;

    void restore(int sz) {
        while (ops.size() > sz) {
            auto [v1, v2] = ops.back();
            p_or_sz[v1] = -(cnt_in_range[v1] >> 13);
            cnt_in_range[v1] &= ((1 << 13) - 1);
            cnt_in_range[v2] -= cnt_in_range[v1];
            p_or_sz[v2] -= p_or_sz[v1];
            ops.pop_back();
        }
    }
};

int n, q, group, versions[max_n], ans[max_n], cnt_gets[max_n];
vector<pair<int, pair<int, int>>> g[max_n], all[max_n];
dsu d;

void calc_cnt_gets(int version) {
    cnt_gets[version] = all[version].size();
    for (auto [id, q] : g[version]) {
        calc_cnt_gets(id);
        cnt_gets[version] += cnt_gets[id];
    }
    for (int i = 0; i < g[version].size(); ++i) {
        if (!cnt_gets[g[version][i].first]) {
            swap(g[version].back(), g[version][i]);
            g[version].pop_back();
        }
    }
}

void dfs(int version) {
    for (auto &[id, q] : all[version]) {
        if (ans[id] != -1) {
            continue;
        }
        auto &[v, k] = q;
        const int root = d.find_set(v);
        const int cnt = d.get_cnt(root);
        if (cnt < k) {
            k -= cnt;
        } else {
            if (cnt == magic) {
                ans[id] = L + k;
            } else {
                for (int i = L; ; ++i) {
                    if (root == d.find_set(i)) {
                        --k;
                        if (!k) {
                            ans[id] = i + 1;
                            break;
                        }
                    }
                }
            }
        }
    }
    const int sz = d.ops.size();
    for (auto [id, q] : g[version]) {
        auto [u, v] = q;
        int root1 = d.find_set(u), root2 = d.find_set(v);
        if (root1 != root2) {
            d.union_set(root1, root2);
        }
        dfs(id);
        d.restore(sz);
    }
}

int main() {
    //freopen("input2.txt", "r", stdin);
    //freopen("output.txt", "w", stdout);
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cin >> n >> q >> group;
    int version = 0, first = 0, cnt_get = 0;
    for (int i = 1; i <= q; ++i) {
        int tp;
        cin >> tp;
        if (tp == 1) {
            versions[i] = version;
            int v, k;
            cin >> v >> k;
            --v;
            all[version].push_back({cnt_get++, {v, k}});
        } else if (tp == 2) {
            int u, v;
            cin >> u >> v;
            --u;
            --v;
            ++first;
            versions[i] = first;
            g[version].push_back({first, {u, v}});
        } else {
            int id;
            cin >> id;
            versions[i] = versions[id];
        }
        version = versions[i];
    }
    calc_cnt_gets(0);
    memset(ans, -1, sizeof(ans));
    L = 0;
    R = magic;
    while (L < n) {
        d.init(n);
        dfs(0);
        L += magic;
        R += magic;
    }
    for (int i = 0; i < cnt_get; ++i) {
        cout << ans[i] << "\n";
    }
    return 0;
}