#include "testlib.h"
#include "parmpars.hpp"
#include <bits/stdc++.h>
using namespace std;

const int MAX_N = 3e3;
const int MAX_Q = 2e5;
const int MAX_C = 1e5;

int A[MAX_N + 1], B[MAX_N + 1], C[MAX_N + 1];
int T[MAX_Q + 1];

int main(int argc, char* argv[]) {
    initGenerator(argc, argv, 1);
    
    DECLARE(int, g);
    DECLARE_D(int, n, MAX_N);
    DECLARE_D(int, q, MAX_Q);
    DECLARE_D(int, CC, MAX_C);
    
    
    DECLARE_D(int, line, 0);
    
    DECLARE_D(int, f, 0);
    
    int sum = 0;
    
    if (f == 0) {
        vector<int> v(n);
        for (int i = 0; i < n; i++) {
            v[i] = i + 1;
        }
        shuffle(v.begin(), v.end());
        for (int i = 1; i < n; i++) {
            if (line) {
                A[i] = i;
                B[i] = i + 1;
            } else {
                int t = rnd.next(i);
                A[i] = v[i];
                B[i] = v[t];
            }
            
            DECLARE_D(int, e, 0);
            
            C[i] = rnd.wnext(CC, e) + 1;
        }
    }
    
    for (int i = 1; i < n; i++) {
        sum += C[i];
    }
    
    DECLARE_D(int, t, sum);
    
    if (g == 1) {
        int s = sum;
        int pos = rnd.next(1, n);
        for (int i = 1; i < n; i++) {
            if (A[i] == pos || B[i] == pos) {
                s -= C[i];
            }
        }
        
        if (t == sum) {
            T[1] = s;
        } else {
            T[1] = rnd.next(s, t);
        }
    } else if (g == 2) {
        int s = sum;
        int pos1 = rnd.next(1, n);
        int pos2 = rnd.next(1, n);
        for (int i = 1; i < n; i++) {
            if (A[i] == pos1 || B[i] == pos1 || A[i] == pos2 || B[i] == pos2) {
                s -= C[i];
            }
        }
        if (t == sum) {
            T[1] = s;
        } else {
            T[1] = rnd.next(s, t);
        }
    } else {
    
        DECLARE_D(int, o, 0);
        
        for (int i = 1; i <= q; i++) {
            T[i] = rnd.wnext(sum, o);
        }
    }
    
    
    

    cout << n << " " << q << " " << g << endl;
    for (int i = 1; i < n; i++) {
        cout << A[i] << " " << B[i] << " " << C[i] << endl;
    }
    for (int i = 1; i <= q; i++) {
        if (i != 1) cout << " ";
        cout << T[i];
    }
    cout << endl;
    
    return 0;
}
