#include "testlib.h"
#include <bits/stdc++.h>

using namespace std;

const int MAX_N = 3e3;
const int MAX_Q = 2e5;
const int MAX_K = 1e9;
const int MAX_C = 1e5;

int MX_N[] = {MAX_N, MAX_N, MAX_N, 200, 10, 200, MAX_N};
int MX_Q[] = {MAX_Q, 1, 1, MAX_Q, 1, MAX_Q, MAX_Q};

vector<pair<int, int> > v[MAX_N + 1];

bool used[MAX_N];

void dfs(int pos) {
    used[pos] = true;
    for (pair<int, int> a : v[pos]) {
        if (!used[a.first]){
            dfs(a.first);
        }
    }
}

int A[MAX_N], B[MAX_N], C[MAX_N];
vector<long long> k;
int n;

bool validate_group_1() {
    int sum = 0;
    for (int i = 1; i < n; i++) {
        sum += C[i];
    }
    int m = INT_MAX;
    for (int a : k) {
        m = min(m, a);
    }
    for (int i = 1; i <= n; i++) {
        int here = sum;
        for (pair<int, int> a : v[i]) {
            here -= a.second;
        }
        if (here <= m) {
            return true;
        }
    }
    return false;
}

bool validate_group_2() {
    int sum = 0;
    for (int i = 1; i < n; i++) {
        sum += C[i];
    }
    int m = INT_MAX;
    for (int a : k) {
        m = min(m, a);
    }
    for (int i = 1; i <= n; i++) {
        for (int j = i + 1; j <= n; j++) {
            int here = sum;
        
            for (pair<int, int> a : v[i]) {
                here -= a.second;
            }
            for (pair<int, int> a : v[j]) {
                if (a.first == i)
                    continue;
                here -= a.second;
            }
            if (here <= m) {
                return true;
            }
        }
    }
    return false;
}

int main(int argc, char* argv[])
{
    registerValidation(argc, argv);
    int group = stoi(validator.group());
    n = inf.readInt(1, MX_N[group], "n");
    inf.readSpace();
    int m = inf.readInt(1, MX_Q[group], "m");
    inf.readSpace();
    int g = inf.readInt(0, 100, "g");
    inf.readEoln();
    ensure(g == group);
    
    for (int i = 1; i < n; i++) {
        int a = inf.readInt(1, n, "a");
        inf.readSpace();
        int b = inf.readInt(1, n, "b");
        inf.readSpace();
        if (g == 3) ensure(a + 1 == b);
        int c = inf.readInt(1, MAX_C, "c");
        inf.readEoln();
        A[i] = a;
        B[i] = b;
        C[i] = c;
        v[a].push_back({b, c});
        v[b].push_back({a, c});
    }
    dfs(1);
    for (int i = 2; i <= n; i++) {
        ensure(used[i]);
    }
    k = inf.readLongs(m, 0LL, MAX_K, "k");
    inf.readEoln();
    inf.readEof();
    
    if (g == 1) ensure(validate_group_1());
    if (g == 2) ensure(validate_group_2());
    
}
