#include <bits/stdc++.h>
using namespace std;

const int MAX = 5e5 + 10;
const int BLOCK_SIZE = 650;
const int BLOCKS = MAX / BLOCK_SIZE + 2;

const int TYPE_ASK = 1;
const int TYPE_UNITE = 2;
const int TYPE_RETURN = 3;

int pr[MAX], size[MAX], ar[MAX];
int T[MAX], A[MAX], B[MAX], Q[MAX];
vector<int> v[MAX];
short int C[MAX][BLOCKS];

inline int dsu_find(int a) {
    while(pr[a] != a) 
        a = pr[a];
    return a;
} 

inline void add(int &a, int &b) {
    a = dsu_find(a);
    b = dsu_find(b);
    if (a == b)
        return;
    if (size[a] > size[b]) {
        int c = a;
        a = b;
        b = c;
    }
    pr[a] = b;
    size[b] += size[a];
    for (int i = 0; i < BLOCKS; i++) {
        C[b][i] += C[a][i];
    }
}

inline void remove(int a, int b) {
    if (a == b)
        return;
    pr[a] = a;
    size[b] -= size[a];
    assert(size[a] <= size[b]);
    for (int i = 0; i < BLOCKS; i++) {
        C[b][i] -= C[a][i];
    }
}

inline int find(int a, int b) {
    a = dsu_find(a);
    if (size[a] < b) {
        return -1;
    }
    int pos = 0;
    while(C[a][pos] < b)
        b -= C[a][pos++];
    pos *= BLOCK_SIZE;
    pos = max(pos, 1);
    while(b > 0) {
        if (dsu_find(pos++) == a)
            b--;
    }
    return pos - 1;
}

void dfs(int pos) {
    if (T[pos] == TYPE_UNITE)
        add(A[pos], B[pos]);
    if (T[pos] == TYPE_ASK)
        Q[pos] = find(A[pos], B[pos]);
    for (int a : v[pos])
        dfs(a);
    if (T[pos] == TYPE_UNITE)
        remove(A[pos], B[pos]);
}

int main(){
	ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    int n, k, g;
    cin >> n >> k >> g;
    for (int i = 1; i <= n; i++) {
        size[i] = 1;
        pr[i] = i;
        C[i][i / BLOCK_SIZE] = 1;
    }
    for (int i = 1; i <= k; i++) {
        cin >> T[i];
        if (T[i] == TYPE_RETURN) {
            cin >> A[i];
            v[A[i]].push_back(i);
        } else {
            cin >> A[i] >> B[i];
            v[i - 1].push_back(i);
        }
    }
    dfs(0);
    for (int i = 1; i <= n; i++) assert(size[i] == 1);
    for (int i = 1; i <= k; i++) {
        if (T[i] == TYPE_ASK) {
            cout << Q[i] << "\n";
        }
    }
}