#include <bits/stdc++.h>
#define int long long
#define pb push_back
using namespace std;

const int maxn = 1e5 + 10;

vector <bool> used (maxn);
vector <int> p (maxn), am (maxn), graph [maxn];
set <int> way;

inline int get (int x){
    if (p[x] == x) return x;
    return p[x] = get (p[x]);
}

inline void unite (int a, int b) {
    a = get (a);
    b = get (b);
    if (a == b) return;
    p[b] = a;
    am[a] += am[b];
}

inline void dfs (int v, int p = -1) {
    int k = get (v);
    way.insert (k);
    for (int i: graph[v]) if (i != p) {
        int j = get (i);
        if (way.count (j)){ unite (v, j);}
        else dfs (i, v);
    }
    way.erase (k);
}

signed main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

	int n, m;
    int u, v;
    cin >> n >> m;
    for (int i = 1; i <= n; ++i) p[i] = i, am[i] = 1;
    while (m--){
        cin >> u >> v;
        graph[u].pb (v);
        graph[v].pb (u);
    }
    dfs (1);
    int res = 0;
    for (int i = 1; i <= n; ++i) if (p[i] == i) res += am[i] * (am[i] - 1) / 2;
    cout << res << '\n';
}
