#include <bits/stdc++.h>
#define int long long
#define pb push_back
using namespace std;

const int maxn = 1e5 + 10;

struct DSU {
    int n;
    vector <int> p, am;
    DSU (int _n) {
        n = _n;
        am.assign (n + 1, 1);
        p.resize (n + 1);
        iota (p.begin (), p.end (), 0);
    }
    int get (int x) {
        if (p[x] == x) return x;
        return p[x] = get (p[x]);
    }
    void unite (int x, int y) {
        x = get (x);
        y = get (y);
        if (x == y) return;
        p[x] = y;
        am[y] += am[x];
    }
};

vector <int> graph [maxn];
vector <int> par (maxn), tin (maxn), tout (maxn);
vector <pair <int, int>> add;
int timer = 0;

inline void dfs (int v, int p = 1) {
    tin[v] = ++timer;
    par[v] = p;
    for (int i: graph[v]) if (i != p) {
        dfs (i, v);
    }
    tout[v] = ++timer;
}

inline bool upper (int a, int b){
    return (tin[a] <= tin[b] && tout[b] <= tout[a]);
}

signed main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    int n, m, u, v;
    cin >> n >> m;
    DSU b (n);
    while (m--) {
        cin >> u >> v;
        int x, y;
        x = u, y = v;
        u = b.get (u);
        v = b.get (v);
        if (u == v) {
            add.push_back (make_pair (x, y));
            continue;
        }
        b.unite (u, v);
        graph[x].pb (y);
        graph[y].pb (x);
    }
    DSU a (n);
    dfs (1);
    for (pair <int, int> i: add) {
        u = i.first, v = i.second;
        int a1 = u;
        //cout << u << ' ' << v << '\n';
        //cout << par [a.get (u)] << '\n';
        while (! upper (a.get (a1), v)) {
            a.unite (a1, par [a.get (a1)]);
        }
        a1 = v;
        while (! upper (a.get (a1), u)) {
            a.unite (a1, par [a.get (a1)]);
        }
    }
    int res = 0;
    /*for (int i = 1; i <= 6; ++i) cout << a.p[i] << ' ';
    cout << '\n';*/
    for (int i = 1; i <= n; ++i) if (a.p[i] == i){
        int x = a.am [i];
        res += (x * (x - 1)) >> 1;
    }
    cout << res << '\n';
}
