#include <bits/stdc++.h>

using namespace std;

using ll = long long;

void dfs(int v, int &t, vector<bool> &used, vector<int> &tin, vector<int> &fup, vector<vector<int>> &adj, set<pair<int, int>> &bridges)
{
    used[v] = true;
    tin[v] = t++;
    fup[v] = tin[v];
    for (int u : adj[v])
    {
        if (used[u])
        {
            fup[v] = min(fup[v], tin[u]);
        }
        else 
        {
            dfs(u, t, used, tin, fup, adj, bridges);
            if (fup[u] >= tin[v])
            {
                bridges.insert({min(u, v), max(u, v)});
            }
            fup[v] = min(fup[v], fup[u]);
        }
    }
}

int dfs2(int v, vector<bool> &used, vector<vector<int>> &adj)
{
    used[v] = true;
    int res = 1;
    for (int u : adj[v]) if (!used[u]) res += dfs2(u, used, adj);
    return res;
}

int main() 
{
    cin.tie(0)->sync_with_stdio(0);
    int n, m;
    cin >> n >> m;
    vector<vector<int>> adj(n + 1);
    vector<pair<int, int>> edges;
    while (m--)
    {
        int u, v;
        cin >> u >> v;
        adj[u].push_back(v);
        adj[v].push_back(u);
        edges.emplace_back(min(u, v), max(u, v));
    }
    set<pair<int, int>> bridges;
    vector<int> tin(n + 1), fup(n + 1);
    vector<bool> used(n + 1);
    int t = 0;
    for (int i = 1; i <= n; ++i) if (!used[i]) dfs(i, t, used, tin, fup, adj, bridges);
    //for (int i = 1; i <= n; ++i) cout << tin[i] << ' ' << fup[i] << '\n';
    adj.clear();
    adj.resize(n + 1);
    //for (auto [u, v] : bridges) cout << u << ' ' << v << '\n';
    for (auto e : edges)
    {
        if (bridges.find(e) == bridges.end()) 
        {
            adj[e.first].push_back(e.second);
            adj[e.second].push_back(e.first);
        }
    }
    ll res = 0;
    used = vector<bool>(n + 1, 0);
    for (int i = 1; i <= n; ++i)
    {
        if (!used[i])
        {
            ll ret = dfs2(i, used, adj);
            res += (ret * (ret - 1)) / 2;
        }
    }
    cout << res;
    return 0;
}
