#pragma GCC optimize("Ofast,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,popcnt,lzcnt")

#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ull = unsigned long long;

constexpr ull P = 29;

int main() 
{
    cin.tie(0)->sync_with_stdio(0);
    string s;
    int q;
    cin >> s >> q;
    int n = s.size();
    vector<pair<int, int>> queries(q + 1);
    int start = 0, end = n - 1;
    queries[0] = {0, n - 1};
    for (int i = 1; i <= q; ++i)
    {
        int t;
        cin >> t;
        if (t == 1) 
        {
            char c;
            cin >> c;
            s += c;
            ++end;
        }
        else ++start;
        queries[i] = {start, end};
    }
    n = s.size();
    vector<ull> help;
    help.reserve((n * (n - 1)) / 2);
#pragma GCC ivdep
    for (int i = 0; i < n; ++i)
    {
        ull hash = 0, po = 1;
        for (int j = i; j < n; ++j, po *= P) 
        {
            hash += po * (s[j] - 'a' + 1);
            //cout << hash << ' ';
            help.push_back(hash);
        }
        //cout << '\n';
    }
    sort(help.begin(), help.end());
    help.erase(unique(help.begin(), help.end()), help.end());
    //cout << help.size() << '\n';
    vector<vector<int>> nhash(n, vector<int>(n));
#pragma GCC ivdep
    for (int i = 0; i < n; ++i)
    {
        ull hash = 0, po = 1;
        for (int j = i; j < n; ++j, po *= P) 
        {
            hash += po * (s[j] - 'a' + 1);
            //cout << hash << ' ';
            nhash[i][j] = distance(help.begin(), lower_bound(help.begin(), help.end(), hash));
        }
        //cout << '\n';
    }
    vector<int> counter(help.size() + 1);
    int res = 0;
    start = 0;
    end = -1;
    for (auto &[l, r] : queries)
    {
        while (end < r)
        {
            ++end;
            for (int i = l; i <= end; ++i)
            {
                ++counter[nhash[i][end]];
                res += counter[nhash[i][end]] == 1;
            }
        }
        while (start < l)
        {
            for (int i = start; i <= r; ++i) 
            {
                res -= counter[nhash[start][i]] == 1;
                --counter[nhash[start][i]];
            }
            ++start;
        }
        cout << res << ' ';
    }
    return 0;
}
