#include <bits/stdc++.h>

using namespace std;

const int INF = 1e6;

int maxLenZrost(const vector<int>& a) {
    if (a.size() < 2) {
        return a.size();
    }
    vector<int> dp(a.size() + 1, INF);
    dp[0] = -INF;
    for (auto i : a) {
        int j = lower_bound(dp.begin(), dp.end(), i) - dp.begin();
        if (j < dp.size()) {
            dp[j] = i;
        }
    }
    int i = 0;
    while (i < dp.size() && dp[i] < INF) {
        ++i;
    }
    return i - 1;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    vector<int> a(n);
    for (auto& i : a) {
        cin >> i;
    }
    int res = 0;
    vector<int> left;
    for (int i = 0; i < a.size(); ++i) {
        vector<int> right;
        left.push_back(a[i]);
        for (int j = i; j < a.size(); ++j) {
            right.push_back(a[j]);
        }
        reverse(right.begin(), right.end());
        res = max(res, maxLenZrost(left) + maxLenZrost(right) - 1);
    }
    cout << res << '\n';
    return 0;
}
