#include <bits/stdc++.h>

using namespace std;

const int INF = 1e6;

int maxLenZrost(const vector<int>& a) {
    if (a.size() < 2) {
        return a.size();
    }
    vector<int> dp(a.size() + 1, INF);
    dp[0] = -INF;
    for (auto i : a) {
        int j = lower_bound(dp.begin(), dp.end(), i) - dp.begin();
        if (j < dp.size()) {
            dp[j] = i;
        }
    }
    int i = lower_bound(dp.begin(), dp.end(), INF) - dp.begin();
    return i - 1;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    vector<int> a(n);
    for (auto& i : a) {
        cin >> i;
    }
    vector<int> maxLenPref(n);
    vector<int> dp(a.size() + 1, INF);
    for (int r = 0; r < n; ++r) {
        int i = a[r];
        int j = lower_bound(dp.begin(), dp.end(), i) - dp.begin();
        if (j < dp.size()) {
            dp[j] = i;
        }
        int ind = lower_bound(dp.begin(), dp.end(), INF) - dp.begin();
        maxLenPref[r] = ind;
    }

    dp.assign(a.size() + 1, INF);
    vector<int> maxLenSuf(n);
    reverse(a.begin(), a.end());
    for (int r = 0; r < n; ++r) {
        int i = a[r];
        int j = lower_bound(dp.begin(), dp.end(), i) - dp.begin();
        if (j < dp.size()) {
            dp[j] = i;
        }
        int ind = lower_bound(dp.begin(), dp.end(), INF) - dp.begin();
        maxLenSuf[n - 1 - r] = ind;
    }

    int res = 0;
    auto right = a;
    reverse(right.begin(), right.end());
    for (int i = 0; i < a.size(); ++i) {
        res = max(res, maxLenPref[i] + maxLenPref[i] - 1);
        right.pop_back();
    }
    cout << res << '\n';
    return 0;
}
