#include <bits/stdc++.h>

using namespace std;

const int N = 1e3;

int p[N];
int sz[N];

void make_set(int i) {
    p[i] = i;
    sz[i] = 1;
}

int find_set(int i) {
    if (i == p[i]) {
        return i;
    }
    return p[i] = find_set(p[i]);
}

void union_set(int a, int b) {
    a = find_set(a);
    b = find_set(b);
    if (a == b) {
        return;
    }
    if (sz[a] < sz[b]) {
        swap(a, b);
    }
    p[b] = a;
    sz[a] += sz[b];
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, m;
    cin >> n >> m;
    vector<pair<int, int>> E(m);
    for (int i = 0; i < E.size(); ++i) {
        cin >> E[i].first >> E[i].second;
        --E[i].first, --E[i].second;
    }
    map<pair<int, int>, int> mp;
    for (int banned = 0; banned < m; ++banned) {
        vector<vector<int>> g(n);
        for (int i = 0; i < n; ++i) {
            make_set(i);
        }
        for (int i = 0; i < m; ++i) {
            if (i == banned) {
                continue;
            }
            int u = E[i].first, v = E[i].second;
            union_set(u, v);
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (find_set(i) == find_set(j)) {
                    ++mp[{i, j}];
                }
            }
        }
    }
    int res = 0;
    for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                res += (mp[{i, j}] == m);
            }
        }
    cout << res << '\n';
    return 0;
}
