#include <bits/stdc++.h>

using namespace std;

int bannedI, bannedJ;

void dfs(int i, const vector<vector<int>>& g, vector<bool>& vis) {
    if (vis[i]) {
        return;
    }
    vis[i] = true;
    for (auto j : g[i]) {
        if (i == bannedI && j == bannedJ) {
            continue;
        }
        if (j == bannedI && i == bannedJ) {
            continue;
        }
        dfs(j, g, vis);
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, m;
    cin >> n >> m;
    vector<pair<int, int>> E(m);
    vector<vector<int>> g(n);
    for (int i = 0; i < m; ++i) {
        int u, v;
        cin >> u >> v;
        --u, --v;
        if (u > v) {
            swap(u, v);
        }
        E.push_back({u, v});
        g[u].push_back(v);
        g[v].push_back(u);
    }
    set<pair<int, int>> banned;
    for (auto p : E) {
        bannedI = p.first;
        bannedJ = p.second;
        vector<bool> vis(n, false);
        dfs(bannedI, g, vis);
        bool hasNotVis = false;
        for (int i = 0; i < n; ++i) {
            if (!vis[i]) {
                hasNotVis = true;
            }
        }
        if (!hasNotVis) {
            continue;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (vis[i] != vis[j]) {
                    banned.insert({i, j});
                }
            }
        }
    }
    cout << n * (n - 1) / 2 - banned.size() << '\n';
    return 0;
}
