#include <bits/stdc++.h>

using namespace std;

const int N = 1e3 + 10;

int p[N];
int sz[N];

void make_set(int i) {
    p[i] = i;
    sz[i] = 1;
}

void init_DSU(int n) {
    for (int i = 0; i < n; ++i) {
        make_set(i);
    }
}

int find_set(int i) {
    if (i == p[i]) {
        return i;
    }
    return p[i] = find_set(p[i]);
}

void union_set(int a, int b) {
    a = find_set(a);
    b = find_set(b);
    if (a == b) {
        return;
    }
    if (sz[a] < sz[b]) {
        swap(a, b);
    }
    p[b] = a;
    sz[a] += sz[b];
}


int bannedI, bannedJ;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, m;
    cin >> n >> m;
    vector<pair<int, int>> E;
    for (int i = 0; i < m; ++i) {
        int u, v;
        cin >> u >> v;
        --u, --v;
        if (u > v) {
            swap(u, v);
        }
        E.push_back({u, v});
    }
    vector<int> bridges;
    for (int j = 0; j < m; ++j) {
        init_DSU(n);
        for (int i = 0; i < m; ++i) {
            if (i == j) {
                continue;
            }
            union_set(E[i].first, E[i].second);
        }
        bool isBridge = false;
        for (int i = 0; i < n; ++i) {
            if (find_set(i) != find_set(0)) {
                isBridge = true;
            }
        }
        if (!isBridge) {
            continue;
        }
        // edge is bridge
        bridges.push_back(j);
        //cout << j << ' ';
    }
    for (int i = 0; i < n; ++i) {
        make_set(i);
    }
    for (int j = 0; j < m; ++j) {
        if (binary_search(bridges.begin(), bridges.end(), j)) {
            continue;
        }
        union_set(E[j].first, E[j].second);
    }
    int res = 0;
    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            res += find_set(i) == find_set(j);
        }
    }
    cout << res << '\n';
    return 0;
}
