#include <bits/stdc++.h>

using namespace std;

const int N = 1e3 + 10;

int p[N];
int sz[N];

void make_set(int i) {
    p[i] = i;
    sz[i] = 1;
}

void init_DSU(int n) {
    for (int i = 0; i < n; ++i) {
        make_set(i);
    }
}

int find_set(int i) {
    if (i == p[i]) {
        return i;
    }
    return p[i] = find_set(p[i]);
}

void union_set(int a, int b) {
    a = find_set(a);
    b = find_set(b);
    if (a == b) {
        return;
    }
    if (sz[a] < sz[b]) {
        swap(a, b);
    }
    p[b] = a;
    sz[a] += sz[b];
}

int tin[N];
int fup[N];

int bannedI, bannedJ;
int t = 0;

vector<pair<int, int>> bridges;

void dfs(int i, const vector<vector<int>>& g, vector<bool>& vis, int p = -1) {
    vis[i] = true;
    tin[i] = t;
    fup[i] = t;
    ++t;
    for (auto j : g[i]) {
        if (j == p) {
            continue;
        }
        if (vis[j]) {
            fup[i] = min(fup[i], fup[j]); 
        } else {
            //cout << i + 1 << ' ' << j + 1 << '\n';
            // can be bridge
            dfs(j, g, vis, i);
            fup[i] = min(fup[i], fup[j]);
            if (tin[i] < fup[j]) {
                bridges.push_back({i, j});
            }
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, m;
    cin >> n >> m;
    vector<pair<int, int>> E;
    vector<vector<int>> g(n);
    for (int i = 0; i < m; ++i) {
        int u, v;
        cin >> u >> v;
        --u, --v;
        if (u > v) {
            swap(u, v);
        }
        E.push_back({u, v});
        g[u].push_back(v);
        g[v].push_back(u);
    }
    vector<bool> vis(n, false);
    dfs(0, g, vis);
    for (auto& [i, j] : bridges) {
        if (i > j) {
            swap(i, j);
        }
    }
    // cout << '\n';
    // for (auto [i, j] : bridges) {
    //     cout << i + 1 << ' ' << j + 1 << '\n';
    // }
    /*vector<int> bridges;
    for (int j = 0; j < m; ++j) {
        init_DSU(n);
        for (int i = 0; i < m; ++i) {
            if (i == j) {
                continue;
            }
            union_set(E[i].first, E[i].second);
        }
        bool isBridge = false;
        for (int i = 0; i < n; ++i) {
            if (find_set(i) != find_set(0)) {
                isBridge = true;
            }
        }
        if (!isBridge) {
            continue;
        }
        // edge is bridge
        bridges.push_back(j);
        //cout << j << ' ';
    }*/
    init_DSU(n);
    for (int j = 0; j < m; ++j) {
        if (find(bridges.begin(), bridges.end(), pair<int, int>{E[j].first, E[j].second}) != bridges.end()) {
            union_set(E[j].first, E[j].second);
            }
    }
    int res = 0;
    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            res += find_set(i) == find_set(j);
        }
    }
    cout << res << '\n';
    return 0;
}
