#include <bits/stdc++.h>

using namespace std;

const int N = 1e5 + 10;

int p[N];
int sz[N];

void make_set(int i) {
    p[i] = i;
    sz[i] = 1;
}

void init_DSU(int n) {
    for (int i = 0; i < n; ++i) {
        make_set(i);
    }
}

int find_set(int i) {
    if (i == p[i]) {
        return i;
    }
    return p[i] = find_set(p[i]);
}

void union_set(int a, int b) {
    a = find_set(a);
    b = find_set(b);
    if (a == b) {
        return;
    }
    if (sz[a] < sz[b]) {
        swap(a, b);
    }
    p[b] = a;
    sz[a] += sz[b];
}

int tin[N];
int fup[N];

int bannedI, bannedJ;
int t = 0;

set<pair<int, int>> bridges;

void addBridge(int i, int j) {
    if (i > j) {
        swap(i, j);
    }
    bridges.insert({i, j});
}

void dfs(int i, const vector<vector<int>>& g, vector<bool>& vis, int p = -1) {
    vis[i] = true;
    tin[i] = t;
    fup[i] = t;
    ++t;
    for (auto j : g[i]) {
        if (j == p) {
            continue;
        }
        if (vis[j]) {
            fup[i] = min(fup[i], fup[j]);
        } else {
            dfs(j, g, vis, i);
            fup[i] = min(fup[i], fup[j]);
            if (tin[i] < fup[j]) {
                addBridge(i, j);
            }
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, m;
    cin >> n >> m;
    vector<pair<int, int>> E;
    vector<vector<int>> g(n);
    for (int i = 0; i < m; ++i) {
        int u, v;
        cin >> u >> v;
        --u, --v;
        if (u > v) {
            swap(u, v);
        }
        E.push_back({u, v});
        g[u].push_back(v);
        g[v].push_back(u);
    }
    vector<bool> vis(n, false);
    dfs(0, g, vis);
    init_DSU(n);
    for (int j = 0; j < m; ++j) {
        if (bridges.find({E[j].first, E[j].second}) == bridges.end()) {
            union_set(E[j].first, E[j].second);
        }
    }
    long long res = 0;
    map<int, int> mp;
    for (int i = 0; i < n; ++i) {
        ++mp[find_set(i)];
    }
    for (auto [key, cnt] : mp) {
        res += cnt * (cnt - 1) / 2;
    }
    cout << res << '\n';
    return 0;
}
