#include <bits/stdc++.h>

using namespace std;

using ll = long long;
constexpr ll mod = 1e9 + 9;
const int N = 1e5;
ll p1[N], p2[N];

int calc(const string& s) {
    vector<ll> v1, v2;
    for (int i = 0; i < s.size(); ++i) {
        ll hash1 = 0, hash2 = 0;
        for (int j = i; j < s.size(); ++j) {
            ll num = s[j] - 'a' + 1;
            hash1 += (num * p1[j - i]) % mod;
            hash1 %= mod;
            v1.push_back(hash1);
            hash2 += (num * p2[j - i]) % mod;
            hash2 %= mod;
            v2.push_back(hash2);
        }
    }
    sort(v1.begin(), v1.end());
    v1.erase(unique(v1.begin(), v1.end()), v1.end());
    sort(v2.begin(), v2.end());
    v2.erase(unique(v2.begin(), v2.end()), v2.end());
    
    return max(v1.size(), v2.size());
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    p1[0] = 1;
    p1[1] = 29;
    for (int i = 2; i < N; ++i) {
        p1[i] = (p1[i - 1] * p1[1]) % mod;
    }
    p2[0] = 1;
    p2[1] = 31;
    for (int i = 2; i < N; ++i) {
        p2[i] = (p2[i - 1] * p2[1]) % mod;
    }
    string s;
    cin >> s;
    cout << calc(s) << ' ';
    int q;
    cin >> q;
    while (q--) {
        int type;
        cin >> type;
        if (type == 1) {
            string add;
            cin >> add;
            s += add;
        } else {
            s.erase(0, 1);
        }
        cout << calc(s) << ' ';
    }
    return 0;
}
