#include <cstdio>
#include <cstring>

const int A = 26;
const int N = 100005;

struct state {
    int link, to[A], len;
    state() {
        link = -1;
        memset(to, 0, A << 2);
        len = 1;
    }
} sa[N << 1];

int last, size = 1;
int add(int c) {
    int cur = last;
    last = size++;
    sa[last].len = sa[cur].len + 1;
    do {
        sa[cur].to[c] = last;
        cur = sa[cur].link;
    } while (cur != -1 && !sa[cur].to[c]);
    if (cur == -1) sa[last].link = 0;
    else {
        int k = sa[cur].to[c];
        if (sa[k].len == sa[cur].len + 1) sa[last].link = k;
        else {
            sa[size] = sa[k];
            sa[size].len = sa[cur].len + 1;
            sa[k].link = sa[last].link = size;
            do {
                sa[cur].to[c] = size;
                cur = sa[cur].link;
            } while (cur != -1 && sa[cur].to[c] == k);
            ++size;
        }
    }
    return sa[last].len - sa[sa[last].link].len;
}

char s[N];

int main() {
    scanf("%s", s);
    long long ans = 0;
    for (int i = 0; s[i]; ++i) ans += add(s[i] - 'a');
    printf("%lld\n", ans);
    return 0;
}
