#include <cstdio>
#include <cstring>

const int A = 26;
const int N = 200005;

struct state {
    int link, to[A], len;
    state() {
        link = -1;
        memset(to, 0, A << 2);
        len = 0;
    }
} sa[N << 1];

int last, size = 1;
int add(int c) {
    int cur = last;
    sa[size] = state();
    last = size++;
    sa[last].len = sa[cur].len + 1;
    do {
        sa[cur].to[c] = last;
        cur = sa[cur].link;
    } while (cur != -1 && !sa[cur].to[c]);
    if (cur == -1) sa[last].link = 0;
    else {
        int k = sa[cur].to[c];
        if (sa[k].len == sa[cur].len + 1) sa[last].link = k;
        else {
            sa[size] = sa[k];
            sa[size].len = sa[cur].len + 1;
            sa[k].link = sa[last].link = size;
            do {
                sa[cur].to[c] = size;
                cur = sa[cur].link;
            } while (cur != -1 && sa[cur].to[c] == k);
            ++size;
        }
    }
    return sa[last].len - sa[sa[last].link].len;
}

char s[N], c[N];
int q, type[N];

int main() {
    scanf("%s%d", s, &q);
    int len = strlen(s);
    long long ans = 0;
    for (int i = 0; s[i]; ++i) ans += add(s[i] - 'a');
    printf("%lld ", ans);
    int rm = 0;
    for (int i = 0; i < q; ++i) {
        scanf("%d", type + i);
        if (type[i] == 1) {
            scanf(" %c", c + i);
            ans += add(c[i] - 'a');
            s[len++] = c[i];
        } else {
            sa[0] = state();
            size = 1;
            last = 0;
            ++rm;
            ans = 0;
            for (int i = rm; s[i]; ++i) ans += add(s[i] - 'a');
        }
        printf("%lld ", ans);
    }
    printf("\n");
    return 0;
}
