#include <cstdio>
#include <cstring>
#include <algorithm>

const int A = 26;
const int N = 200005;

struct state {
    int link, to[A], len;
    state() {
        link = -1;
        memset(to, 0, A << 2);
        len = 0;
    }
} sa[N << 1];

int last, size = 1;
int add_c(int c) {
    int cur = last;
    sa[size] = state();
    last = size++;
    sa[last].len = sa[cur].len + 1;
    do {
        sa[cur].to[c] = last;
        cur = sa[cur].link;
    } while (cur != -1 && !sa[cur].to[c]);
    if (cur == -1) sa[last].link = 0;
    else {
        int k = sa[cur].to[c];
        if (sa[k].len == sa[cur].len + 1) sa[last].link = k;
        else {
            sa[size] = sa[k];
            sa[size].len = sa[cur].len + 1;
            sa[k].link = sa[last].link = size;
            do {
                sa[cur].to[c] = size;
                cur = sa[cur].link;
            } while (cur != -1 && sa[cur].to[c] == k);
            ++size;
        }
    }
    return sa[last].len - sa[sa[last].link].len;
}

char s[N], c[N];
int n, q, type[N], rpos[N << 1], add[N << 1], l[N], r[N];
long long ans[N], t[N << 1];

void inc(int l, int r, int d, int v = 0, int tl = 0, int tr = n) {
    if (!(tl >= r || tr <= l)) {
        if (tl >= l && tr <= r) {
            add[v] += d;
            t[v] += d * (tr - tl);
        } else {
            int m = tl + tr >> 1;
            inc(l, r, d, v + 1, tl, m);
            inc(l, r, d, v + (tr - tl & ~1), m, tr);
            t[v] = t[v + 1] + t[v + (tr - tl & ~1)] + (long long)add[v] * (tr - tl);
        }
    }
}

long long query(int l, int r, int v = 0, int tl = 0, int tr = n) {
    if (tl >= r || tr <= l) return 0;
    if (tl >= l && tr <= r) return t[v];
    int m = tl + tr >> 1;
    return query(l, r, v + 1, tl, m) + query(l, r, v + (tr - tl & ~1), m, tr) + (long long)add[v] * (std::min(tr, r) - std::max(l, tl));
}

int main() {
    scanf("%s%d", s, &q);
    n = strlen(s);
    l[0] = 0;
    r[0] = n - 1;
    for (int i = 0; i < q; ++i) {
        scanf("%d", type + i);
        l[i + 1] = l[i];
        r[i + 1] = r[i];
        if (type[i] == 1) {
            scanf(" %c", c + i);
            s[n++] = c[i];
            ++r[i + 1];
        } else ++l[i + 1];
    }
    for (int i = 0; i < n; ++i) add_c(s[i] - 'a');
    int st = 0;
    for (int i = 0, j = 0; i < n; ++i) {
        st = sa[st].to[s[i] - 'a'];
        inc(0, i + 1, 1);
        rpos[st] = i + 1;
        for (int v = sa[st].link; v; v = sa[v].link) {
            inc(rpos[v] - sa[v].len, rpos[v] - sa[sa[v].link].len, -1);
            rpos[v] = i + 1;
        }
        while (j <= q && r[j] == i) {
            printf("%lld ", query(l[j], i + 1));
            ++j;
        }
    }
    printf("\n");
    return 0;
}
