#include <cstdio>
#include <cstring>
#include <algorithm>

const int A = 26;
const int N = 200005;

struct state {
    int link, to[A], len;
    state() {
        link = -1;
        memset(to, 0, A << 2);
        len = 0;
    }
} sa[N << 1];

int last, size = 1;
int add_c(int c) {
    int cur = last;
    sa[size] = state();
    last = size++;
    sa[last].len = sa[cur].len + 1;
    do {
        sa[cur].to[c] = last;
        cur = sa[cur].link;
    } while (cur != -1 && !sa[cur].to[c]);
    if (cur == -1) sa[last].link = 0;
    else {
        int k = sa[cur].to[c];
        if (sa[k].len == sa[cur].len + 1) sa[last].link = k;
        else {
            sa[size] = sa[k];
            sa[size].len = sa[cur].len + 1;
            sa[k].link = sa[last].link = size;
            do {
                sa[cur].to[c] = size;
                cur = sa[cur].link;
            } while (cur != -1 && sa[cur].to[c] == k);
            ++size;
        }
    }
    return sa[last].len - sa[sa[last].link].len;
}

char s[N], c[N];
int n, q, type[N], rpos[N << 1], add[N << 1], l[N], r[N];
long long ans[N], t[N << 1];

struct bit {
    std::vector<long long> b;
    bit() {
        b.resize(N);
    }
    void add(int i, int d) {
        while (i < N) {
            b[i] += d;
            i |= i + 1;
        }
    }
    long long get(int i) {
        long long s = 0;
        while (i >= 0) {
            s += b[i];
            i = (i & i + 1) - 1;
        }
        return s;
    }
} b0, b1;

void inc(int l, int r, int d) {
    b1.add(l, d);
    b1.add(r, -d);
    b0.add(l, -d * l);
    b0.add(r, d * r);
}

long long pquery(int r) {
    return b0.get(r) + b1.get(r) * r;
}

long long query(int l, int r) {
    return pquery(r) - pquery(l);
}

int main() {
    scanf("%s%d", s, &q);
    n = strlen(s);
    l[0] = 0;
    r[0] = n - 1;
    for (int i = 0; i < q; ++i) {
        scanf("%d", type + i);
        l[i + 1] = l[i];
        r[i + 1] = r[i];
        if (type[i] == 1) {
            scanf(" %c", c + i);
            s[n++] = c[i];
            ++r[i + 1];
        } else ++l[i + 1];
    }
    for (int i = 0; i < n; ++i) add_c(s[i] - 'a');
    int st = 0;
    for (int i = 0, j = 0; i < n; ++i) {
        st = sa[st].to[s[i] - 'a'];
        inc(0, i + 1, 1);
        rpos[st] = i + 1;
        for (int v = sa[st].link; v; v = sa[v].link) {
            if (rpos[v]) inc(rpos[v] - sa[v].len, rpos[v] - sa[sa[v].link].len, -1);
            rpos[v] = i + 1;
        }
        while (j <= q && r[j] == i) {
            printf("%lld ", query(l[j], i + 1));
            ++j;
        }
    }
    printf("\n");
    return 0;
}
