//#pragma GCC optimize("Ofast,unroll-loops")
//#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")
#include <cstdio>
#include <random>
#include <cstring>
#include <vector>
#include <algorithm>

const int A = 26;
const int N = 200005;

struct state {
    int link, to[A], len;
    state() {
        link = -1;
        memset(to, 0, A << 2);
        len = 0;
    }
} sa[N << 1];

int last, size = 1;
int add_c(int c) {
    int cur = last;
    sa[size] = state();
    last = size++;
    sa[last].len = sa[cur].len + 1;
    do {
        sa[cur].to[c] = last;
        cur = sa[cur].link;
    } while (cur != -1 && !sa[cur].to[c]);
    if (cur == -1) sa[last].link = 0;
    else {
        int k = sa[cur].to[c];
        if (sa[k].len == sa[cur].len + 1) sa[last].link = k;
        else {
            sa[size] = sa[k];
            sa[size].len = sa[cur].len + 1;
            sa[k].link = sa[last].link = size;
            do {
                sa[cur].to[c] = size;
                cur = sa[cur].link;
            } while (cur != -1 && sa[cur].to[c] == k);
            ++size;
        }
    }
    return sa[last].len - sa[sa[last].link].len;
}

char s[N], c[N];
int n, q, type[N], l[N], r[N];
long long ans[N];
std::vector<int> g[N << 1];

struct bit {
    std::vector<long long> b;
    bit() {
        b.resize(N);
    }
    void add(int i, int d) {
        while (i < N) {
            b[i] += d;
            i |= i + 1;
        }
    }
    long long get(int i) {
        long long s = 0;
        while (i >= 0) {
            s += b[i];
            i = (i & i + 1) - 1;
        }
        return s;
    }
} b0, b1;

int op = 0;
void inc(int l, int r, int d) {
    ++op;
    b1.add(l, d);
    b1.add(r, -d);
    b0.add(l, -d * l);
    b0.add(r, d * r);
}

long long pquery(int r) {
    return b0.get(r) + b1.get(r) * r;
}

long long query(int l, int r) {
    return pquery(r) - pquery(l);
}

std::mt19937 rng;

int sz[N << 1], in[N << 1], inv[N << 1], top[N << 1];

void dfs(int v) {
    sz[v] = 1;
    for (int i = 0; i < (int)g[v].size(); ++i) {
        dfs(g[v][i]);
        sz[v] += sz[g[v][i]];
        if (sz[g[v][i]] > sz[g[v][0]]) std::swap(g[v][i], g[v][0]);
    }
}

void dfs1(int v) {
    static int dt = 0;
    inv[dt] = v;
    in[v] = dt++;
    for (int i = 0; i < (int)g[v].size(); ++i) {
        if (i) top[g[v][i]] = g[v][i];
        else top[g[v][i]] = top[v];
        dfs1(g[v][i]);
    }
}

struct item {
    int mx;
    bool many, upd;
    item() {
        mx = many = upd = 0;
    }
} t[N << 2];

item operator+(item &a, item &b) {
    item res;
    res.mx = std::max(a.mx, b.mx);
    res.many = a.many || b.many || a.mx != b.mx;
    return res;
}

void push(int v, int tl, int tr) {
    if (tr - tl > 1 && t[v].upd) {
        t[v + 1].mx = t[v + (tr - tl & ~1)].mx = t[v].mx;
        t[v + 1].many = t[v + (tr - tl & ~1)].many = 0;
        t[v + 1].upd = t[v + (tr - tl & ~1)].upd = 1;
        t[v].upd = 0;
    }
}

void maxeq(int l, int r, int x, int v = 0, int tl = 0, int tr = size) {
    if (!(tl >= r || tr <= l)) {
        if (tl >= l && tr <= r && !t[v].many) {
            int fi = inv[tl], la = inv[tr - 1];
            if (t[v].mx) inc(t[v].mx - sa[la].len, t[v].mx - sa[sa[fi].link].len, -1);
            t[v].mx = x;
            t[v].upd = 1;
        } else {
            push(v, tl, tr);
            int m = tl + tr >> 1;
            maxeq(l, r, x, v + 1, tl, m);
            maxeq(l, r, x, v + (tr - tl & ~1), m, tr);
            t[v] = t[v + 1] + t[v + (tr - tl & ~1)];
        }
    }
}

int main() {
    scanf("%s%d", s, &q);
    n = strlen(s);
    l[0] = 0;
    r[0] = n - 1;
    for (int i = 0; i < q; ++i) {
        scanf("%d", type + i);
        l[i + 1] = l[i];
        r[i + 1] = r[i];
        if (type[i] == 1) {
            scanf(" %c", c + i);
            s[n++] = c[i];
            ++r[i + 1];
        } else ++l[i + 1];
    }
    for (int i = 0; i < n; ++i) add_c(s[i] - 'a');
    for (int i = 1; i < size; ++i) g[sa[i].link].push_back(i);
    dfs(0);
    dfs1(0);
    int st = 0;
    for (int i = 0, j = 0; i < n; ++i) {
        st = sa[st].to[s[i] - 'a'];
        inc(0, i + 1, 1);
        for (int v = st; v; v = sa[v].link) {
            maxeq(in[top[v]] + !top[v], in[v] + 1, i + 1);
            v = top[v];
            if (!v) break;
        }
        while (j <= q && r[j] == i) {
            printf("%lld ", query(l[j], i + 1));
            ++j;
        }
    }
    return 0;
}
