#pragma GCC optimize("Ofast,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,popcnt,lzcnt")

#include <bits/stdc++.h>
#include <ext/pb_ds/tree_policy.hpp>
#include <ext/pb_ds/assoc_container.hpp>

using namespace std;
using namespace __gnu_pbds;

using ordered_set = tree<int, null_type, greater<>, rb_tree_tag, tree_order_statistics_node_update>;
using ordered_set2 = tree<int, null_type, less<>, rb_tree_tag, tree_order_statistics_node_update>;

using ll = long long;

struct SegTree
{

    int n;
    vector<vector<int>> tree;

    void build(int v, int l, int r, vector<int> &a)
    {
        if (l > r) return;
        if (l == r)
        {
            tree[v].push_back(a[l]);
            return;
        }
        int m = (l + r) >> 1;
        build(v << 1, l, m, a);
        build(v << 1 | 1, m + 1, r, a);
        tree[v].resize(tree[v << 1].size() + tree[v << 1 | 1].size());
        merge(tree[v << 1].begin(), tree[v << 1].end(), tree[v << 1 | 1].begin(), tree[v << 1 | 1].end(), tree[v].begin());
    }

    SegTree(vector<int> &a) : n(a.size())
    {
        tree.resize(4 * n + 5);
        build(1, 0, n - 1, a);
    }

    int get(int a, int b, int x, int l, int r, int v)
    {
        if (a > r || b < l) return 0;
        if (a == l && b == r)
        {
            //count < x
            return (int)distance(tree[v].begin(), upper_bound(tree[v].begin(), tree[v].end(), x));
        }
        int m = (l + r) >> 1;
        return get(a, min(b, m), x, l, m, v << 1) + get(max(a, m + 1), b, x, m + 1, r, v << 1 | 1);
    }

    int get(int a, int x)
    {
        return get(a, n - 1, x, 0, n - 1, 1);
    }

};

int main()
{
    cin.tie(0)->sync_with_stdio(0);
    int n;
    cin >> n;
    vector<int> a(n);
    for (int &i : a) 
    {
        cin >> i;
        --i;
    }
    vector<int> ati(n);
    for (int i = 0; i < n; ++i) ati[a[i]] = i;
    vector<int> dp(n + 1, 1e9);
    dp[0] = 0;
    //SegTree st(ati);
    vector<vector<int>> suff(n + 1, vector<int>(n));
    set<int> help2;
    for (int i = n - 1; i >= 0; --i) 
    {
        help2.insert(ati[i]);
        auto it = help2.begin();
        int cnt = 0;
        for (int j = 0; j < n; ++j) 
        {
            while (it != help2.end() && *it < j)
            {
                ++it;
                ++cnt;
            }
            suff[i][j] = cnt;
        }
    }
    ordered_set help;
    for (int i = 0; i < n; ++i)
    {
        int swaps = 0;
        for (int j = i; j >= 0; --j)
        {
            swaps += help.order_of_key(ati[j]);
            //if (n < 1000) swaps += st.get(i + 1, ati[j]);
            swaps += suff[i + 1][ati[j]];
            help.insert(ati[j]);
            dp[i + 1] = min(dp[i + 1], dp[j] + swaps);
        }
        help.clear();
    }
    cout << dp[n];
    return 0;
}
