#include <bits/stdc++.h>

using namespace std;

using ll = long long;

const ll INF = 1e18;

struct edge
{
    int u;
    int c;
    ll p;

    edge(int _u = 0, int _c = 0, ll _p = 0) : u(_u), c(_c), p(_p)
    {}

};

void dijkstra(int v, int m, vector<ll> &d, vector<vector<edge>> &adj)
{
    vector<bool> used(adj.size());
    priority_queue<pair<ll, int>, vector<pair<ll, int>>, greater<>> pq;
    d[v] = 0;
    vector<int> counter(m + 1);
    pq.push({0, v});
    while (!pq.empty())
    {
        int v = pq.top().second;
        pq.pop();
        if (used[v]) continue;
        used[v] = true;
        for (edge e : adj[v]) ++counter[e.c];
        for (edge e : adj[v])
        {
            if (counter[e.c] == 1)
            {
                if (d[e.u] > d[v])
                {
                    d[e.u] = d[v];
                    pq.push({d[e.u], e.u});
                }
            }
            else 
            {
                if (d[e.u] > d[v] + e.p)
                {
                    d[e.u] = d[v] + e.p;
                    pq.push({d[e.u], e.u});
                }
            }
        }
        for (edge e : adj[v]) --counter[e.c];
    }
}

int main()
{
    cin.tie(0)->sync_with_stdio(0);
    int n, m;
    cin >> n >> m;
    int sm = m;
    vector<vector<edge>> adj(n + 1);
    while (m--)
    {
        int a, b, c;
        ll p;
        cin >> a >> b >> c >> p;
        adj[a].emplace_back(b, c, p);
        adj[b].emplace_back(a, c, p);
    }
    vector<ll> dp(n + 1, INF);
    dijkstra(1, sm, dp, adj);
    if (dp[n] == INF) cout << -1;
    else cout << dp[n];
    return 0;
}
