#include <bits/stdc++.h>

using namespace std;

using ll = long long;

const ll INF = 1e18;

struct edge
{
    int u;
    int c;
    ll p;
    int ind;

    edge(int _u = 0, int _c = 0, ll _p = 0, int _ind = 0) : u(_u), c(_c), p(_p), ind(_ind)
    {}

};

void dijkstra(int v, int m, vector<vector<ll>> &d, vector<vector<edge>> &adj)
{
    vector<vector<bool>> used(adj.size());
    for (int i = 1; i < adj.size(); ++i) used[i].resize(adj[i].size());
    priority_queue<pair<ll, pair<int, int>>, vector<pair<ll, pair<int, int>>>, greater<>> pq;
    d[v][(int)adj[v].size() - 1] = 0;
    vector<int> counter(m + 1);
    pq.push({0, {v, (int)adj[v].size() - 1}});
    while (!pq.empty())
    {
        auto [v, i] = pq.top().second;
        pq.pop();
        if (used[v][i] || v == 0) continue;
        used[v][i] = true;
        for (int j = 0; j < adj[v].size(); ++j) if (i != j && adj[v][j].u != 0) ++counter[adj[v][j].c];
        for (int j = 0; j < adj[v].size(); ++j) if (i != j && adj[v][j].u != 0)
        {
            edge e = adj[v][j];
            if (counter[e.c] == 1)
            {
                if (d[e.u][e.ind] > d[v][i])
                {
                    d[e.u][e.ind] = d[v][i];
                    pq.push({d[e.u][e.ind], {e.u, e.ind}});
                }
            }
            else 
            {
                if (d[e.u][e.ind] > d[v][i] + e.p)
                {
                    d[e.u][e.ind] = d[v][i] + e.p;
                    pq.push({d[e.u][e.ind], {e.u, e.ind}});
                }
            }
        }
        for (int j = 0; j < adj[v].size(); ++j) if (i != j && adj[v][j].u != 0) --counter[adj[v][j].c];
    }
}

int main()
{
    cin.tie(0)->sync_with_stdio(0);
    int n, m;
    cin >> n >> m;
    int sm = m;
    vector<vector<edge>> adj(n + 1);
    while (m--)
    {
        int a, b, c;
        ll p;
        cin >> a >> b >> c >> p;
        adj[a].emplace_back(b, c, p, adj[b].size());
        adj[b].emplace_back(a, c, p, (int)adj[a].size() - 1);
    }
    adj[1].emplace_back(0, -1, 0, 0);
    vector<vector<ll>> dp(n + 1);
    for (int i = 1; i <= n; ++i) dp[i].resize(adj[i].size(), INF);
    dijkstra(1, sm, dp, adj);
    ll minim = *min_element(dp[n].begin(), dp[n].end());
    if (minim == INF) cout << -1;
    else cout << minim;
    return 0;
}
