#include <bits/stdc++.h>

using namespace std;

using ll = long long;
const ll INF = 1e17;

vector<ll> winds;

ll calc(const ll lefti, const ll righti) {
    ll res = 0;
    ll dx = 0, minD = 0, maxD = 0;;
    for (auto w : winds) {
        if (w > 0) {
            ll to = min(righti - abs(minD), dx + w);
            ll from = max(dx, maxD);
            res += max(0LL, to - from);
        } else if (w < 0) {
            ll to = min(dx, minD);
            ll from = max(-(lefti - maxD), dx + w);
            res += max(0LL, to - from);
        }
        dx += w;
        minD = min(dx, minD);
        maxD = max(dx, maxD);
    }
    return res;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, q;
    cin >> n >> q;
    vector<ll> x(n);
    for (auto& i : x) {
        cin >> i;
    }
    vector<ll> right(n), left(n);
    for (int i = 0; i < n - 1; ++i) {
        right[i] = x[i + 1] - x[i];
    }
    right[n - 1] = INF;
    left[0] = INF;
    for (int i = 1; i < n; ++i) {
        left[i] = x[i] - x[i - 1];
    }
    vector<ll> ans(n);
    winds.resize(n);
    for (auto& i : winds) {
        cin >> i;
    }
    for (int i = 0; i < n; ++i) {
        ans[i] = calc(left[i], right[i]);
    }
    for (auto i : ans) {
        cout << i << '\n';
    }
    return 0;
}

