#include <bits/stdc++.h>

using namespace std;

using ll = long long;

struct edge {
    int v, c, w;
};

const int INF = 1e7;

vector<int> dijkstra(int start, const vector<vector<edge>>& g) {
    vector<int> d(g.size(), INF);
    d[start] = 0;
    set<pair<int, int>> s; // {d[i], i}
    for (int i = 0; i < g.size(); ++i) {
        s.insert({d[i], i});
    }
    while (!s.empty()) {
        auto [di, i] = *s.begin();
        s.erase(s.begin());
        for (auto [j, c, w] : g[i]) {
            if (d[i] + w < d[j]) {
                s.erase({d[j], j});
                d[j] = d[i] + w;
                s.insert({d[j], j});
            }
        }
    }
    return d;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, m;
    cin >> n >> m;
    vector<vector<edge>> g(n);
    for (int i = 0; i < m; ++i) {
        int u, v, c, p;
        cin >> u >> v >> c >> p;
        --u, --v;
        g[u].push_back({v, c, 1});
        g[v].push_back({u, c, 1});
    }
    int d = dijkstra(0, g)[n - 1];
    cout << (d < INF ? d : -1) << '\n';
    return 0;
}
