#include <cstdio>
#include <vector>
#include <map>
#include <queue>
#include <set>

const int N = 100005;
int n, m;

struct edge {
    int to, c, p;
} e[N << 2];

std::vector<int> g[N];
std::map<int, long long> col[N];

struct state {
    long long dist;
    int edg, v;
    bool rm;
};

bool operator<(state a, state b) {
    return a.dist > b.dist;
}

std::set<std::pair<std::pair<int, int>, bool> > vis;

int main() {
    scanf("%d%d", &n, &m);
    for (int i = 0; i < m; ++i) {
        int a, b, c, p;
        scanf("%d%d%d%d", &a, &b, &c, &p);
        --a;
        --b;
        e[i << 1] = {b, c, p};
        e[i << 1 | 1] = {a, c, p};
        g[a].push_back(i << 1);
        g[b].push_back(i << 1 | 1);
        col[a][c] += p;
        col[b][c] += p;
    }
    std::priority_queue<state> pq;
    pq.push({0, m * 2, 0, 0});
    while (!pq.empty()) {
        state cur = pq.top();
        pq.pop();
        if (cur.v == n - 1) {
            printf("%lld\n", cur.dist);
            return 0;
        }
        if (vis.insert(std::make_pair(std::make_pair(cur.edg, cur.v), cur.rm)).second) {
            for (int i = 0; i < (int)g[cur.v].size(); ++i) {
                int eid = g[cur.v][i];
                edge go = e[eid];
                if (go.c == e[cur.edg].c) {
                    if (cur.rm) pq.push({cur.dist + col[cur.v][go.c] - e[cur.edg].p - go.p, eid, go.to, 0});
                    pq.push({cur.dist + go.p, eid, go.to, 1});
                } else {
                    pq.push({cur.dist + go.p, eid, go.to, 1});
                    pq.push({cur.dist + col[cur.v][go.c] - go.p, eid, go.to, 0});
                }
            }
        }
    }
    printf("-1\n");
    return 0;
}
