#include <cstdio>
#include <vector>
#include <map>
#include <queue>
#include <cstring>
#include <algorithm>
#include <set>

const int N = 100005;
int n, m;

struct edge {
    int to, c, p;
} e[N << 2];

std::vector<int> g[N];
long long csum[N << 2];
std::pair<std::pair<int, int>, int> edg[N << 2];

struct state {
    long long dist;
    int edg;
    bool rm;
};

bool operator<(state a, state b) {
    if (a.dist == b.dist) return a.edg == b.edg ? a.rm < b.rm : a.edg < b.edg;
    return a.dist < b.dist;
}

long long res[N << 3];

std::set<std::pair<long long, int> > st;

void push(long long x, int k) {
    if (res[k] > x) {
        st.erase(std::make_pair(res[k], k));
        res[k] = x;
        st.insert(std::make_pair(res[k], k));
    }
}

int main() {
    scanf("%d%d", &n, &m);
    for (int i = 0; i < m; ++i) {
        int a, b, c, p;
        scanf("%d%d%d%d", &a, &b, &c, &p);
        --a;
        --b;
        e[i << 1] = {b, c, p};
        e[i << 1 | 1] = {a, c, p};
        g[a].push_back(i << 1);
        g[b].push_back(i << 1 | 1);
        edg[i << 1] = std::make_pair(std::make_pair(c, a), i << 1);
        edg[i << 1 | 1] = std::make_pair(std::make_pair(c, b), i << 1 | 1);
    }
    std::sort(edg, edg + m * 2);
    for (int i = 0; i < m * 2;) {
        int fi = i;
        long long all = 0;
        do {
            all += e[edg[i].second].p;
            ++i;
        } while (i < m * 2 && edg[i].first == edg[i - 1].first);
        for (; fi < i; ++fi) csum[edg[fi].second] = all;
    }
    memset(res, 0xf, N << 6);
    push(0, m * 4);
    if (m > 2000) return 1;
    while (!st.empty()) {
        state cur;
        cur.dist = st.begin()->first;
        cur.edg = st.begin()->second >> 1;
        cur.rm = st.begin()->second & 1;
        st.erase(st.begin());
        int v = e[cur.edg].to;
        if (v == n - 1) {
            printf("%lld\n", cur.dist);
            return 0;
        }
        for (int i = 0; i < (int)g[v].size(); ++i) {
            int eid = g[v][i];
            edge go = e[eid];
            if (go.c == e[cur.edg].c) {
                if (cur.rm) push(cur.dist + csum[eid] - e[cur.edg].p - go.p, eid << 1);
            } else push(cur.dist + csum[eid] - go.p, eid << 1);
            push(cur.dist + go.p, eid << 1 | 1);
        }
    }
    printf("-1\n");
    return 0;
}

