#include <cstdio>
#include <vector>
#include <map>
#include <queue>
#include <cstring>
#include <algorithm>
#include <set>

const int N = 100005;
int n, m;

struct edge {
    int to, c, p;
} e[N << 2];

std::vector<int> g[N];
long long csum[N << 2];
int simple[N];
std::pair<std::pair<int, int>, int> edg[N << 2];
std::map<int, long long> colorsum[N];

long long res[N << 3];

std::set<std::pair<long long, int> > st;
std::set<std::pair<int, int> > vis;

void push(long long x, int k) {
    if (res[k] > x) {
        st.erase(std::make_pair(res[k], k));
        res[k] = x;
        st.insert(std::make_pair(res[k], k));
    }
}

struct state {
    long long dist;
    int v, c;
};

bool operator<(state a, state b) {
    return a.dist > b.dist;
}

bool cmp(int a, int b) {
    return e[a].c < e[b].c;
}

int main() {
    scanf("%d%d", &n, &m);
    for (int i = 0; i < m; ++i) {
        int a, b, c, p;
        scanf("%d%d%d%d", &a, &b, &c, &p);
        --a;
        --b;
        e[i << 1] = {b, c, p};
        e[i << 1 | 1] = {a, c, p};
        g[a].push_back(i << 1);
        g[b].push_back(i << 1 | 1);
        edg[i << 1] = std::make_pair(std::make_pair(c, a), i << 1);
        edg[i << 1 | 1] = std::make_pair(std::make_pair(c, b), i << 1 | 1);
        colorsum[a][c] += p;
        colorsum[b][c] += p;
    }
    for (int i = 0; i < n; ++i) std::sort(g[i].begin(), g[i].end(), cmp);
    std::sort(edg, edg + m * 2);
    for (int i = 0; i < m * 2;) {
        int fi = i;
        long long all = 0;
        do {
            all += e[edg[i].second].p;
            ++i;
        } while (i < m * 2 && edg[i].first == edg[i - 1].first);
        for (; fi < i; ++fi) csum[edg[fi].second] = all;
    }
    memset(res, 0xf, N << 6);
    push(0, m * 4);
    e[m * 2].c = -2;
    std::priority_queue<state> colorq;
    while (!st.empty() || !colorq.empty()) {
        if (st.empty() || !colorq.empty() && colorq.top().dist <= st.begin()->first) {
            long long dist = colorq.top().dist;
            int v = colorq.top().v, c = colorq.top().c;
            colorq.pop();
            if (vis.insert(std::make_pair(v, c)).second) {
                int l = 0, r = (int)g[v].size();
                while (l < r) {
                    int m = l + r >> 1;
                    if (e[g[v][m]].c >= c) r = m;
                    else l = m + 1;
                }
                for (int i = r; i < (int)g[v].size() && e[g[v][i]].c == c; ++i) {
                    int eid = g[v][i];
                    edge go = e[eid];
                    if (go.c == c) push(dist + colorsum[v][c] - go.p, eid << 1);
                }
            }
        } else {
            long long dist = st.begin()->first;
            int edg = st.begin()->second >> 1;
            bool rm = st.begin()->second & 1;
            st.erase(st.begin());
            int v = e[edg].to;
            if (v == n - 1) {
                printf("%lld\n", dist);
                return 0;
            }
            if (simple[v] != -1 && simple[v] != e[edg].c) {
                if (simple[v]) simple[v] = -1;
                else simple[v] = e[edg].c;
                for (int i = 0; i < (int)g[v].size(); ++i) {
                    int eid = g[v][i];
                    edge go = e[eid];
                    push(dist + go.p, eid << 1 | 1);
                    colorq.push({dist, go.to, go.c});
                    if (go.c != e[edg].c) push(dist + csum[eid] - go.p, eid << 1);
                }
            }
        }
    }
    printf("-1\n");
    return 0;
}

