#include <bits/stdc++.h>

using namespace std;

using ll = long long;

const ll MOD = 1e9 + 7;

struct segtree
{
    int n;
    vector<array<array<ll, 8>, 8>> tree;
    vector<int> a;
    array<array<ll, 8>, 8> zero;

    array<array<ll, 8>, 8> merge(array<array<ll, 8>, 8> a, array<array<ll, 8>, 8> b)
    {
        array<array<ll, 8>, 8> res;
        for (int i = 0; i < 8; ++i)
        {
            for (int j = 0; j < 8; ++j)
            {
                res[i][j] = 0;
                for (int k = 0; k < 8; ++k)
                {
                    for (int l = 0; l < 8; ++l)
                    {
                        if ((k & l) == 0)
                        {
                            ll va = 1;
                            int t = k | l;
                            if (t == 0) va = 3;
                            else if ((t & 1) == 0  && (t & 2) == 0) va = 2;
                            else if ((t & 2) == 0  && (t & 4) == 0) va = 2;
                            res[i][j] = (res[i][j] + a[i][k] * b[l][j] * va) % MOD;
                        }
                    }
                }
            }
        }
        return res;
    }

    void build(int l, int r, int v)
    {
        if (l > r) return;
        if (l == r)
        {
            for (int i = 0; i < 8; ++i)
            {
                for (int j = 0; j < 8; ++j)
                {
                    tree[v][i][j] = 0;
                    if (i & j) continue;
                    if (i & a[l]) continue;
                    if (j & a[l]) continue;
                    int t = i | j | a[l];
                    if (t == 0) tree[v][i][j] = 3;
                    else if ((t & 1) == 0  && (t & 2) == 0) tree[v][i][j] = 2;
                    else if ((t & 2) == 0  && (t & 4) == 0) tree[v][i][j] = 2;
                    else tree[v][i][j] = 1;
                }
            }
            /*cout << l << ":\n";
            for (int i = 0; i < 8; ++i)
            {
                for (int j = 0; j < 8; ++j) cout << tree[v][i][j] << ' ';
                cout << '\n';
            }*/
            return;
        }
        int m = (l + r) >> 1;
        build(l, m, v << 1);
        build(m + 1, r, v << 1 | 1);
        tree[v] = merge(tree[v << 1], tree[v << 1 | 1]);
    }

    void update(int p, int x, int l, int r, int v)
    {
        if (l > r) return;
        if (l == r)
        {
            a[l] ^= (1 << x);
            for (int i = 0; i < 8; ++i)
            {
                for (int j = 0; j < 8; ++j)
                {
                    tree[v][i][j] = 0;
                    if (i & j) continue;
                    if (i & a[l]) continue;
                    if (j & a[l]) continue;
                    int t = i | j | a[l];
                    if (t == 0) tree[v][i][j] = 3;
                    else if ((t & 1) == 0  && (t & 2) == 0) tree[v][i][j] = 2;
                    else if ((t & 2) == 0  && (t & 4) == 0) tree[v][i][j] = 2;
                    else tree[v][i][j] = 1;
                }
            }
            return;
        }
        int m = (l + r) >> 1;
        if (p <= m) update(p, x, l, m, v << 1);
        else update(p, x, m + 1, r, v << 1 | 1);
        tree[v] = merge(tree[v << 1], tree[v << 1 | 1]);
    }

    array<array<ll, 8>, 8> get(int a, int b, int l, int r, int v)
    {
        if (a > r || b < l) return zero;
        if (a == l && b == r) return tree[v];
        int m = (l + r) >> 1;
        return merge(get(a, min(b, m), l, m, v << 1), get(max(a, m + 1), b, m + 1, r, v << 1 | 1));
    }

    segtree(vector<int> _a) : n((int)_a.size()), a(_a)
    {
        for (int i = 0; i < 8; ++i) for (int j = 0; j < 8; ++j) zero[i][j] = i == j;
        tree.resize(4 * n + 5);
        build(0, n - 1, 1);
    }

    ll get(int a, int b)
    {
        array<array<ll, 8>, 8> dp = get(a, b, 0, n - 1, 1);
        for (int i = 0; i < 8; ++i)
        {
            for (int j = 0; j < 8; ++j) cout << dp[i][j] << ' ';
            cout << '\n';
        }
        return dp[0][0];
    }

    void update(int p, int x)
    {
        update(p, x, 0, n - 1, 1);
    }

};

int main()
{
    cin.tie(0)->sync_with_stdio(false);
    int n, q;
    cin >> n >> q;
    string in;
    cin >> in;
    vector<int> a(n);
    for (int i = 0; i < n; ++i) a[i] += in[i] == 'x';
    cin >> in;
    for (int i = 0; i < n; ++i) a[i] += 2* (in[i] == 'x');
    cin >> in;
    for (int i = 0; i < n; ++i) a[i] += 4 * (in[i] == 'x');
    segtree st(a);
    while (q--)
    {
        int t;
        cin >> t;
        if (t == 1)
        {
            int x, y;
            cin >> x >> y;
            st.update(y - 1, x - 1);
        }
        else
        {
            int l, r;
            cin >> l >> r;
            cout << st.get(l - 1, r - 1) << '\n';
        }
    }
    return 0;
}
