#include <bits/stdc++.h>

using namespace std;

set<int> visited;

void calcGo(const vector<long long>& x, int from, int to, int& t, int& res) {
    if (from == to) {
        return;
    }
    if (from < to) {
        for (int i = from + 1; i <= to; ++i) {
            t += x[i] - x[i - 1];
            if (!visited.count(i)) {
                res += t;
                visited.insert(i);
            }
        }
    } else {
        for (int i = from - 1; i >= to; --i) {
            t += x[i + 1] - x[i];
            if (!visited.count(i)) {
                res += t;
                visited.insert(i);
            }
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n, k;
    cin >> n >> k;
    --k;
    vector<int> a(n - 1);
    for (auto& i : a) {
        cin >> i;
    }
    vector<long long> x(n);
    x[0] = 0;
    for (int i = 1; i < n; ++i) {
        x[i] = x[i - 1] + a[i - 1];
    }
    int res = 2e9;
    for (int i = 0; i <= k; ++i) {
        visited.clear();
        visited.insert(k);
        int t = 0, currRes = 0;
        calcGo(x, k, i, t, currRes);
        calcGo(x, i, n - 1, t, currRes);
        if (i != 0) {
            calcGo(x, n - 1, 0, t, currRes);
        }
        res = min(res, currRes);
    }
    for (int i = k; i < n; ++i) {
        visited.clear();
        visited.insert(k);
        int t = 0, currRes = 0;
        calcGo(x, k, i, t, currRes);
        calcGo(x, i, 0, t, currRes);
        if (visited.size() < n) {
            calcGo(x, 0, n - 1, t, currRes);
        }
        res = min(res, currRes);
    }
    cout << res << '\n';
    return 0;
}

