#pragma GCC optimize("O3")
#include <cstdio>
#include <algorithm>
#include <utility>

const int N = 300000;
int n, a[N], b[N];
std::pair<int, int> aord[N], bord[N];
long double bt[N];

void update(int i, long double x) {
    while (i < n) {
        bt[i] = std::min(bt[i], x);
        i |= i + 1;
    }
}

long double get(int i) {
    long double res = 1e18;
    while (i >= 0) {
        res = std::min(res, bt[i]);
        i = (i & i + 1) - 1;
    }
    return res;
}

bool test1(long double x) {
    for (int i = 0; i < n; ++i) bt[i] = 1e18;
    for (int i = 0; i < n; ++i) {
        long double val = a[bord[i].second] * x + bord[i].first;
        if (get(bord[i].second - 1) <= val) return 0;
        update(bord[i].second, val);
    }
    return 1;
}

bool test2(long double x) {
    for (int i = 0; i < n; ++i) bt[i] = 1e18;
    for (int i = 0; i < n; ++i) {
        long double val = aord[i].first * x + b[aord[i].second];
        if (get(aord[i].second - 1) <= val) return 0;
        update(aord[i].second, val);
    }
    return 1;
}

int main() {
    scanf("%d", &n);
    for (int i = 0; i < n; ++i) {
        scanf("%d", &aord[i].first);
        aord[i].second = i;
        a[i] = aord[i].first;
    }
    for (int i = 0; i < n; ++i) {
        scanf("%d", &bord[i].first);
        bord[i].second = i;
        b[i] = bord[i].first;
    }
    std::sort(aord, aord + n);
    std::sort(bord, bord + n);
    long double l = 0, r = 12432142412;
    for (int it = 0; it < 50; ++it) {
        long double m = (l + r) / 2;
        if (test1(m)) r = m;
        else l = m;
    }
    long double res = l;
    l = 0;
    r = 12432142412;
    for (int it = 0; it < 50; ++it) {
        long double m = (l + r) / 2;
        if (test2(m)) l = m;
        else r = m;
    }
    printf("%s\n", res < l ? "YES" : "NO");
    //printf("%lf %lf\n", (double)res, (double)l);
    return 0;
}
