#include <cstdio>
#include <cstring>

const int md = 1000000007;

inline int add(int a, int b) {
    a += b;
    if (a >= md) a -= md;
    return a;
}
inline int mul(int a, int b) {
    return (long long)a * b % md;
}

struct item {
    int d[8][8], len;
    item() {
        len = 0;
        memset(*d, 0, 8 * 8 << 2);
    }
    void set(int x) {
        len = 1;
        for (int i = 0; i < 8; ++i) if (!(x & i)) {
            ++d[i][i];
            int fill = x | i;
            if (fill & 1 ^ 1 && fill >> 1 & 1 ^ 1) ++d[i][i];
            if (fill >> 1 & 1 ^ 1 && fill >> 2 & 1 ^ 1) ++d[i][i];
        }
    }
};

item operator+(item a, item b) {
    if (!a.len) return b;
    if (!b.len) return a;
    item res;
    res.len = a.len + b.len;
    if (a.len == 1) {
        if (b.len == 1) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    for (int k = 0; k < 8; ++k) if (!(j & k) && !(i & k)) {
                        res.d[i][j] = add(res.d[i][j], mul(a.d[i | k][i | k], b.d[j | k][j | k]));
                    }
                }
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    for (int k = 0; k < 8; ++k) if (!(i & k)) {
                        res.d[i][j] = add(res.d[i][j], mul(a.d[i | k][i | k], b.d[k][j]));
                    }
                }
            }
        }
    } else if (b.len == 1) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) if (!(j & k)) {
                    res.d[i][j] = add(res.d[i][j], mul(a.d[i][k], b.d[j | k][j | k]));
                }
            }
        }
    } else {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    res.d[i][j] = add(res.d[i][j], mul(a.d[i][k], b.d[k][j]));
                }
            }
        }
    }
    return res;
}

const int N = 30000;
int n, q, a[N];
char s[N + 1];
item t[N << 1];

void build(int v = 0, int tl = 0, int tr = n) {
    if (tr - tl == 1) {
        t[v].set(a[tl]);
    } else {
        int m = tl + tr >> 1;
        build(v + 1, tl, m);
        build(v + (tr - tl & ~1), m, tr);
        t[v] = t[v + 1] + t[v + (tr - tl & ~1)];
    }
}

void update(int i, int x, int v = 0, int tl = 0, int tr = n) {
    if (tr - tl == 1) {
        t[v] = item();
        t[v].set(x);
    } else {
        int m = tl + tr >> 1;
        if (i < m) update(i, x, v + 1, tl, m);
        else update(i, x, v + (tr - tl & ~1), m, tr);
        t[v] = t[v + 1] + t[v + (tr - tl & ~1)];
    }
}

item get(int l, int r, int v = 0, int tl = 0, int tr = n) {
    if (tl >= r || tr <= l) return item();
    if (tl >= l && tr <= r) return t[v];
    int m = tl + tr >> 1;
    return get(l, r, v + 1, tl, m) + get(l, r, v + (tr - tl & ~1), m, tr);
}

int main() {
    scanf("%d%d", &n, &q);
    for (int i = 0; i < 3; ++i) {
        scanf("%s", s);
        for (int j = 0; j < n; ++j) if (s[j] == 'x') a[j] |= 1 << i;
    }
    build();
    while (q--) {
        int x, y, z;
        scanf("%d%d%d", &x, &y, &z);
        if (x == 1) {
            --y;
            --z;
            a[z] ^= 1 << y;
            update(z, a[z]);
        } else {
            item res = get(y - 1, z);
            printf("%d\n", res.d[0][0]);
        }
    }
    return 0;
}
