#include <cstdio>
#include <set>
#include <queue>

const int N = 300000;
int n, k;
long long d[N];

struct seg {
    long long dist;
    int l, r;
    bool ri;
};

bool operator<(seg a, seg b) {
    return a.dist > b.dist;
}

std::set<std::pair<std::pair<int, int>, bool> > was;

int main() {
    scanf("%d%d", &n, &k);
    --k;
    for (int i = 1; i < n; ++i) {
        scanf("%lld", d + i);
        d[i] += d[i - 1];
    }
    std::priority_queue<seg> pq;
    pq.push({0, k, k, 0});
    while (!pq.empty()) {
        seg cur = pq.top();
        pq.pop();
        if (was.insert(std::make_pair(std::make_pair(cur.l, cur.r), cur.ri)).second) {
            fflush(stdout);
            if (!cur.l && cur.r == n - 1) {
                printf("%lld\n", cur.dist);
                return 0;
            }
            int un = n - cur.r + cur.l - 1;
            pq.push({cur.dist + (d[cur.r] - d[cur.l]) * un, cur.l, cur.r, !cur.ri});
            if (cur.ri && cur.r + 1 < n) pq.push({cur.dist + (d[cur.r + 1] - d[cur.r]) * un, cur.l, cur.r + 1, cur.ri});
            if (!cur.ri && cur.l) pq.push({cur.dist + (d[cur.l] - d[cur.l - 1]) * un, cur.l - 1, cur.r, cur.ri});
        }
    }
    return 1;
}
