#include "testlib.h"

using namespace std;

const int N = 8;

const char queen = 'Q'; // ферзь
const char king = 'K'; // король
const char pawn = 'p'; // пішак
const char rook = 'r'; // тура
const char knight = 'n'; // кінь
const char bishop = 'b'; // слон

int main(int argc, char* argv[]) {
    registerGen(argc, argv, 1);
    char a[N][N];
    for (auto& i : a) {
        for (auto& j : i) {
            j = '.';
        }
    }
    int bishopI = rnd.next(0, N - 1), bishopJ = rnd.next(0, N - 1);
    a[bishopI][bishopJ] = bishop;
    for (int k = 0; k < 1; ++k) {
        int i = rnd.next(0, N - 1);
        int j = rnd.next(0, N - 1);
        if (a[i][j] != '.' || (i + j) % 2 == (bishopI + bishopJ) % 2) {
            --k;
            continue;
        }
        a[i][j] = bishop;
    }
    for (int k = 0; k < 8; ++k) {
        int i = rnd.next(1, 6);
        int j = rnd.next(0, N - 1);
        if (a[i][j] != '.') {
            --k;
            continue;
        }
        a[i][j] = pawn;
    }
    for (int k = 0; k < 2; ++k) {
        int i = rnd.next(0, N - 1);
        int j = rnd.next(0, N - 1);
        if (a[i][j] != '.') {
            --k;
            continue;
        }
        a[i][j] = rook;
    }
    for (int k = 0; k < 2; ++k) {
        int i = rnd.next(0, N - 1);
        int j = rnd.next(0, N - 1);
        if (a[i][j] != '.') {
            --k;
            continue;
        }
        a[i][j] = knight;
    }
    for (int k = 0; k < 1; ++k) {
        int i = rnd.next(0, N - 1);
        int j = rnd.next(0, N - 1);
        if (a[i][j] != '.') {
            --k;
            continue;
        }
        a[i][j] = queen;
    }
    for (int k = 0; k < 1; ++k) {
        int i = rnd.next(0, N - 1);
        int j = rnd.next(0, N - 1);
        if (a[i][j] != '.') {
            --k;
            continue;
        }
        a[i][j] = king;
    }

    for (auto& i : a) {
        for (auto& j : i) {
            cout << j;
        }
        cout << '\n';
    }
}