#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

const int N = 8;
const char queen = 'Q'; // ферзь
const char king = 'K'; // король
const char pawn = 'p'; // пішак
const char rook = 'r'; // тура
const char knight = 'n'; // кінь
const char bishop = 'b'; // слон

char a[N][N];
bool canMoveThere[N][N];

bool isCoord(int i, int j) {
    return 0 <= i && i < 8 && 0 <= j && j < 8;
}

string toChessCoords(int i, int j) {
    return string(1, 'a' + j) + to_string(8 - i);
}

int baningI, baningJ;
int kingI, kingJ;
vector<string> figuresThatBan;

void ban(int i, int j) {
    if (isCoord(i, j)) {
        if (i == kingI && j == kingJ) {
            figuresThatBan.push_back(toChessCoords(baningI, baningJ));
        }
        canMoveThere[i][j] = false;
    }
}

bool isEmpty(int i, int j) {
    if (!isCoord(i, j)) return true;
    return a[i][j] == '.';
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < N; ++j) {
            cin >> a[i][j];
            if (a[i][j] == king) {
                a[i][j] = '.';
                kingI = i;
                kingJ = j;
            }
            if (a[i][j] == '.') {
                canMoveThere[i][j] = true;
            } else {
                canMoveThere[i][j] = false;
            }
        }
    }
    for (int i = -1; i <= 1; ++i) {
        for (int j = -1; j <= 1; ++j) {
            if (i == 0 && j == 0) continue;
            if (isCoord(kingI + i, kingJ + j)) {
                canMoveThere[kingI + i][kingJ + j] = true;
            }
        }
    }

    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < N; ++j) {
            baningI = i;
            baningJ = j;
            if (a[i][j] == pawn) {
                ban(i - 1, j - 1);
                ban(i - 1, j + 1);
            } else if (a[i][j] == rook) {
                for (int k = 1; k < N; ++k) {
                    ban(i, j + k);
                    if (!isEmpty(i, j + k)) break;
                }
                for (int k = 1; k < N; ++k) {
                    ban(i, j - k);
                    if (!isEmpty(i, j - k)) break;
                }
                for (int k = 1; k < N; ++k) {
                    ban(i + k, j);
                    if (!isEmpty(i + k, j)) break;
                }
                for (int k = 1; k < N; ++k) {
                    ban(i - k, j);
                    if (!isEmpty(i - k, j)) break;
                }
            } else if (a[i][j] == knight) {
                ban(i - 2, j - 1);
                ban(i - 2, j + 1);
                ban(i - 1, j + 2);
                ban(i + 1, j + 2);
                ban(i + 2, j + 1);
                ban(i + 2, j - 1);
                ban(i + 1, j - 2);
                ban(i - 1, j - 2);
            } else if (a[i][j] == bishop) {
                for (int k = 1; k <= 8; ++k) {
                    ban(i - k, j - k);
                    if (!isEmpty(i - k, j - k)) break;
                    
                }
                for (int k = 1; k <= 8; ++k) {
                    ban(i + k, j + k);
                    if (!isEmpty(i + k, j + k)) break;
                    
                }
                for (int k = 1; k <= 8; ++k) {
                    ban(i - k, j + k);
                    if (!isEmpty(i - k, j + k)) break;
                    
                }
                for (int k = 1; k <= 8; ++k) {
                    ban(i + k, j - k);
                    if (!isEmpty(i + k, j - k)) break;
                    
                }
            } else if (a[i][j] == queen) {
                // from rook
                for (int k = 1; k < N; ++k) {
                    ban(i, j + k);
                    if (!isEmpty(i, j + k)) break;
                }
                for (int k = 1; k < N; ++k) {
                    ban(i, j - k);
                    if (!isEmpty(i, j - k)) break;
                }
                for (int k = 1; k < N; ++k) {
                    ban(i + k, j);
                    if (!isEmpty(i + k, j)) break;
                }
                for (int k = 1; k < N; ++k) {
                    ban(i - k, j);
                    if (!isEmpty(i - k, j)) break;
                }

                // from bihop
                for (int k = 1; k <= 8; ++k) {
                    ban(i - k, j - k);
                    if (!isEmpty(i - k, j - k)) break;
                    
                }
                for (int k = 1; k <= 8; ++k) {
                    ban(i + k, j + k);
                    if (!isEmpty(i + k, j + k)) break;
                    
                }
                for (int k = 1; k <= 8; ++k) {
                    ban(i - k, j + k);
                    if (!isEmpty(i - k, j + k)) break;
                    
                }
                for (int k = 1; k <= 8; ++k) {
                    ban(i + k, j - k);
                    if (!isEmpty(i + k, j - k)) break;
                    
                }
            }
        }
    }

    vector<string> availableMoves;
    for (int i = -1; i <= 1; ++i) {
        for (int j = -1; j <= 1; ++j) {
            if (i == 0 && j == 0) continue;
            if (isCoord(kingI + i, kingJ + j) && canMoveThere[kingI + i][kingJ + j]) {
                availableMoves.push_back(toChessCoords(kingI + i, kingJ + j));
            }
        }
    }
    sort(availableMoves.begin(), availableMoves.end());
    sort(figuresThatBan.begin(), figuresThatBan.end());
    if (!canMoveThere[kingI][kingJ] && availableMoves.empty()) { // мат
        cout << "Checkmate\n";
        for (auto& i : figuresThatBan) {
            cout << i << '\n';
        }
    } else if (canMoveThere[kingI][kingJ] && availableMoves.empty()) { // пат
        cout << "Stalemate\n";
    } else {
        cout << "Continue\n";
        for (auto& i : availableMoves) {
            cout << i << '\n';
        }
    }
    return 0;
}
