#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

struct atm {
    long long x, c;
};

const long long INF = 2e18;

long long calc(long long capacity, const long long w, const vector<atm>& v) {
    vector<long long> dp(v.size(), INF); // dp[i] = min price to get to atm #i
    dp[0] = 0;
    for (int i = 1; i < v.size(); ++i) {
        for (int j = 0; j < i; ++j) {
            if (w * (v[i].x - v[j].x) <= capacity && dp[j] < INF) {
                dp[i] = min(dp[i], dp[j] + w * (v[i].x - v[j].x) * v[j].c);
            }
        }
    }
    return dp.back();
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    long long d, w;
    cin >> d >> w;
    int n;
    cin >> n;
    vector<atm> v(n);
    for (auto& [x, c] : v) {
        cin >> c;
    }
    for (auto& [x, c] : v) {
        cin >> x;
    }
    sort(v.begin(), v.end(), [](const atm& a, const atm& b) {
        if (a.x == b.x) return a.c < b.c;
        return a.x < b.x;
    });
    v.erase(unique(v.begin(), v.end(), [](const atm& a, const atm& b) {
        return a.x == b.x;
    }), v.end());
    v.push_back({d, 0});

    long long minPrice = calc(numeric_limits<long long>::max(), w, v);
    long long left = 0, right = 1e13;
    while (left + 1 < right) {
        long long mid = (left + right) / 2;
        if (calc(mid, w, v) <= minPrice) {
            right = mid;
        } else {
            left = mid;
        }
    }
    cout << right << '\n';
    return 0;
}
