#include "testlib.h"
using namespace std;
int n;
const int MAX = 1e6 + 10;
int t[MAX];

void init(){
    for (int i = 1; i <= n; i++) {
        t[i] = i;
    }
}

int get(int pos) {
    return t[pos] = (pos == t[pos] ? pos : get(t[pos]));
}

void unite(int a, int b) {
    cout << a << " " << b << endl;
    t[get(a)] = get(b);
}

bool check(InStream &in) {
    string res = in.readToken("YES|NO", "yesno");
    if (res == "YES") {
        return true;
    }
    int a = in.readInt(1, n, "a");
    int b = in.readInt(1, n, "b");
    if (a == b) {
        in.quitf(_wa, "same number");
    }
    if (get(a) == get(b)) {
        in.quitf(_wa, "same component");
    }
    return false;
}

signed main(int argc,char *argv[]){
	registerTestlibCmd(argc, argv);
	n = inf.readInt();
	init();
	for (int i = 1; i <= n; i++) {
	    int j = i + i;
	    if (j > n) {
	        j -= n;
	    }
	    unite(i, j);
	}
	bool jury = check(ans);
	bool part = check(ouf);
	if (jury == part) {
	    quitf(_ok, "OK");
	}
	if (jury) {
	    quitf(_fail, "Jury didn't find");
	} else {
	    quitf(_wa, "participant didn't find");
	}
	
	quitf(_ok,"OK");
}

