#include "testlib.h"
#include <iostream>
#include <string>
#include <algorithm>
using namespace std;
const int MAX_K = (int)5e3;
struct rect{
	int x1,y1,x2,y2;
	rect(int _x1 = 0,int _y1 = 0,int _x2 = 0,int _y2 = 0):x1(_x1),x2(_x2),y1(_y1),y2(_y2){
	}
} A[MAX_K+7];
int n,m;
void gen(int &x1,int &y1,int &x2,int &y2){
	int lx = rnd.next(0,n);
	int ly = rnd.next(0,m);
	x1 = rnd.next(0,n-lx);
	y1 = rnd.next(0,m-ly);
	x2 = x1+lx;
	y2 = y1+ly;
}
bool intersect(const rect &a,const rect &b){
	pair<int,int> sg_x = make_pair(max(a.x1,b.x1),min(a.x2,b.x2));
	pair<int,int> sg_y = make_pair(max(a.y1,b.y1),min(a.y2,b.y2));
	return sg_x.second>=sg_x.first && sg_y.second>=sg_y.first;
}
int sd(const rect &cur){
	if (cur.x1==0 || cur.y2==m){
		return 0;
	}
	if (cur.x2==n || cur.y1==0){
		return 1;
	}
	return 2;
}
bool check(int sz,const rect &cur){
	int csd = sd(cur);
	for(int i = 1;i<sz;i+=1){
		if (csd+sd(A[i])==1){
			return 0;
		}
	}
	return 1;
}
signed main(int argc,char *argv[]){
	registerGen(argc, argv, 1);
	string type = opt<string>(1);
	int k_l = opt<int>(2);
	int k_r = opt<int>(3);
	int n_l = opt<int>(4);
	int n_r = opt<int>(5);
	n = rnd.next(n_l,n_r);
	m = rnd.next(n_l,n_r);
	int k = rnd.next(k_l,k_r);
	int percent = opt<int>(6);
	if (type=="NO"){
		if (k==1){
			gen(A[1].x1,A[1].y1,A[1].x2,A[1].y2);
			if (rnd.next(1,2)==1){
				A[1].x1 = 0,A[1].x2 = n;
			}
			else{
				A[1].y1 = 0,A[1].y2 = m;
			}
		}
		else if (k==2){
			{
				rect &cur = A[1];	
				gen(cur.x1,cur.y1,cur.x2,cur.y2);
				int rd = rnd.next(1,4);
				if (rd==1){
					cur.x1 = 0;
				}
				if (rd==2){
					cur.y1 = 0;
				}
				if (rd==3){
					cur.x2 = n;
				}
				if (rd==4){
					cur.y2 = m;
				}
			}
			{
				rect &cur = A[2];
				while(!intersect(A[1],A[2]) || (cur.x1==0 && cur.y1==0) || (cur.x2==n && cur.y2==m)){
					gen(cur.x1,cur.y1,cur.x2,cur.y2);
					int rd = rnd.next(1,4);
					if (rd==1){
						cur.x1 = 0;
					}
					if (rd==2){
						cur.y1 = 0;
					}
					if (rd==3){
						cur.x2 = n;
					}
					if (rd==4){
						cur.y2 = m;
					}
				}	
			}
		
		}
		else if (k==3){
			for(int i = 1;i<=k;i+=1){
				rect cur(0,0,0,0);
				while((cur.x1==0 && cur.y1==0) || (cur.x2==n && cur.y2==m)){
					gen(cur.x1,cur.y1,cur.x2,cur.y2);
					if (rnd.next(1,100)<=percent){
						int rd = rnd.next(1,4);
						if (rd==1){
							cur.x1 = 0;
						}
						if (rd==2){
							cur.y1 = 0;
						}
						if (rd==3){
							cur.x2 = n;
						}
						if (rd==4){
							cur.y2 = m;
						}
					}
				}
				A[i] = cur;
			}	
		}
		else{
			for(int i = 1;i<=k;i+=1){
				rect cur(0,0,0,0);
				while(!check(i,cur) || (cur.x1==0 && cur.y1==0) || (cur.x2==n && cur.y2==m)){
					gen(cur.x1,cur.y1,cur.x2,cur.y2);
					if (rnd.next(1,100)<=percent){
						int rd = rnd.next(1,4);
						if (rd==1){
							cur.x1 = 0;
						}
						if (rd==2){
							cur.y1 = 0;
						}
						if (rd==3){
							cur.x2 = n;
						}
						if (rd==4){
							cur.y2 = m;
						}
					}
				}
				A[i] = cur;
			}
		}
	}
	else if (type=="YES"){
		for(int i = 1;i<=k;i+=1){
			rect cur(0,0,0,0);
			while((cur.x1==0 && cur.y1==0) || (cur.x2==n && cur.y2==m)){
				gen(cur.x1,cur.y1,cur.x2,cur.y2);
				if (rnd.next(1,100)<=percent){
					int rd = rnd.next(1,4);
					if (rd==1){
						cur.x1 = 0;
					}
					if (rd==2){
						cur.y1 = 0;
					}
					if (rd==3){
						cur.x2 = n;
					}
					if (rd==4){
						cur.y2 = m;
					}
				}
			}
			A[i] = cur;
		}
	}
	cout<<n<<' '<<m<<' '<<k<<endl;
	for(int i = 1;i<=k;i+=1){
		cout<<A[i].x1<<' '<<A[i].y1<<' '<<A[i].x2<<' '<<A[i].y2<<endl;
	}
}
 
 


