#include <iostream>
#include <algorithm>
#include <vector>
#include <queue>
using namespace std;
#define endl '\n'
const int N = 5007;
struct rect{
	int x1,y1,x2,y2;
	void read(){
		cin>>x1>>y1>>x2>>y2;
	}
} A[N];
bool intersect(const rect &a,const rect &b){
	pair<int,int> sg_x = make_pair(max(a.x1,b.x1),min(a.x2,b.x2));
	pair<int,int> sg_y = make_pair(max(a.y1,b.y1),min(a.y2,b.y2));
	return sg_x.second>=sg_x.first && sg_y.second>=sg_y.first;
}
bool vis[N];
queue<int> Q;
bool get(int n,const vector<int> &start,const vector<int> &fin){
	for(int i = 1;i<=n;i+=1){
		vis[i] = 0;
	}
	while(!Q.empty()){
		Q.pop();
	}
	for(int to:start){
		Q.push(to);
		vis[to] = 1;
	}
	while(!Q.empty()){
		int v = Q.front();
		Q.pop();
		for(int i = 1;i<=n;i+=1){
			if (!vis[i] && intersect(A[v],A[i])){
				vis[i] = 1;
				Q.push(i);
			}
		}
	}
	for(int to:fin){
		if (vis[to]){
			return 1;
		}
	}
	return 0;
}
void solve(){
	int n,m,k;
	cin>>n>>m>>k;
	for(int i = 1;i<=k;i+=1){
		A[i].read();
	}
	vector<int> start,fin;
	// start - top
	for(int i = 1;i<=k;i+=1){
		if (A[i].y1==0){
			start.push_back(i);
		}
		if (A[i].x2==n){
		    start.push_back(i);
		}
		if (A[i].x1==0){
			fin.push_back(i);
		}
		if (A[i].y2==m){
			fin.push_back(i);
		}
	}
	if (get(k,start,fin)){
		cout<<"NO\n";
		return;
	}
	cout<<"YES\n";
}
signed main(){
	ios_base::sync_with_stdio(0); cin.tie(0);
	solve();
}

