/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CrossRun {
    private static List<String> messages = Collections.synchronizedList(new ArrayList());
    private static volatile boolean failed = false;

    private static void error(String string) {
        System.out.println("ERROR: " + string);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            CrossRun.error("Expected exactly two arguments: the first process command line and the second process command line.");
        }
        long l = System.currentTimeMillis();
        try {
            CrossRun.runProcesses(stringArray);
        }
        catch (IOException iOException) {
            CrossRun.error(iOException.getMessage());
        }
        System.out.println("Completed in " + (System.currentTimeMillis() - l) + " ms.");
    }

    private static void runProcesses(String[] stringArray) throws IOException {
        Process process = new ProcessBuilder(stringArray[0].split(" ")).start();
        Process process2 = new ProcessBuilder(stringArray[1].split(" ")).start();
        Thread thread = new Thread(new StreamProxyRunner("first", "second", process.getInputStream(), process2.getOutputStream()));
        Thread thread2 = new Thread(new StreamProxyRunner("second", "first", process2.getInputStream(), process.getOutputStream()));
        thread.start();
        thread2.start();
        int n = -1;
        try {
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            CrossRun.error(interruptedException.getMessage());
        }
        int n2 = -1;
        try {
            n2 = process2.waitFor();
        }
        catch (InterruptedException interruptedException) {
            CrossRun.error(interruptedException.getMessage());
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            CrossRun.error(interruptedException.getMessage());
        }
        try {
            thread2.join();
        }
        catch (InterruptedException interruptedException) {
            CrossRun.error(interruptedException.getMessage());
        }
        if (n != 0) {
            messages.add("The first process returned with exit code " + n + ".");
        }
        if (n2 != 0) {
            messages.add("The second process returned with exit code " + n2 + ".");
        }
        for (String string : messages) {
            System.out.println("* " + string);
        }
        if (failed) {
            System.exit(1);
        }
    }

    private static final class StreamProxyRunner
    implements Runnable {
        private final String firstProcessName;
        private final String secondProcessName;
        private final InputStream inputStream;
        private final OutputStream outputStream;

        private StreamProxyRunner(String string, String string2, InputStream inputStream, OutputStream outputStream) {
            this.firstProcessName = string;
            this.secondProcessName = string2;
            this.inputStream = inputStream;
            this.outputStream = outputStream;
        }

        @Override
        public void run() {
            byte[] byArray = new byte[65536];
            while (true) {
                int n;
                try {
                    n = this.inputStream.read(byArray);
                }
                catch (IOException iOException) {
                    messages.add("Unexpected exception " + iOException.getClass().getSimpleName() + " while reading from the output of the " + this.firstProcessName + " process: " + iOException.getMessage());
                    failed = true;
                    break;
                }
                if (n < 0) break;
                try {
                    this.outputStream.write(byArray, 0, n);
                    this.outputStream.flush();
                }
                catch (IOException iOException) {
                    messages.add("Unexpected exception " + iOException.getClass().getSimpleName() + " while writing to the input of the " + this.secondProcessName + " process: " + iOException.getMessage());
                    failed = true;
                    break;
                }
            }
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

