#!/usr/bin/env bash
#   *** validation ***
scripts/run-validator-tests.sh
scripts/run-checker-tests.sh

#    *** tests ***
mkdir -p tests
echo "Generating test #4"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 2 1 2 10 1 1 1" "tests/04" 4
echo "Generating test #5"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 2 1 2 10 2 2 3" "tests/05" 5
echo "Generating test #6"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 2 1 2 10 2 1 4" "tests/06" 6
echo "Generating test #7"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 1 1 10 3 3 5" "tests/07" 7
echo "Generating test #8"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 1 1 100 20 20 2" "tests/08" 8
echo "Generating test #9"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 1 1 100 1 1 1" "tests/09" 9
echo "Generating test #10"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 1 1 100 51 51 1" "tests/10" 10
echo "Generating test #11"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 1 1 100 99 99 3" "tests/11" 11
echo "Generating test #12"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 1 1 100 2 2 3" "tests/12" 12
echo "Generating test #13"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 1 1 100 3 2 1" "tests/13" 13
echo "Generating test #14"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 100 2 1 1" "tests/14" 14
echo "Generating test #15"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 100 1000 999 1" "tests/15" 15
echo "Generating test #16"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 2 1 2 100 1 2 1" "tests/16" 16
echo "Generating test #17"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 1 1 10 3 4 5" "tests/17" 17
echo "Generating test #18"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 1 1 100 19 20 2" "tests/18" 18
echo "Generating test #19"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 1 1 100 1 2 1" "tests/19" 19
echo "Generating test #20"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 1 1 100 50 51 1" "tests/20" 20
echo "Generating test #21"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 1 1 100 99 100 3" "tests/21" 21
echo "Generating test #22"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 1 1 100 2 3 3" "tests/22" 22
echo "Generating test #23"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 100 1 2 1" "tests/23" 23
echo "Generating test #24"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 100 999 1000 1" "tests/24" 24
echo "Generating test #25"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 10 3 3 5" "tests/25" 25
echo "Generating test #26"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 100 20 20 2" "tests/26" 26
echo "Generating test #27"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 500 1 1 4" "tests/27" 27
echo "Generating test #28"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 1000 51 51 1" "tests/28" 28
echo "Generating test #29"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 5000 99 99 3" "tests/29" 29
echo "Generating test #30"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 7500 51 50 1" "tests/30" 30
echo "Generating test #31"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 9000 100 99 3" "tests/31" 31
echo "Generating test #32"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 10000 2 1 1" "tests/32" 32
echo "Generating test #33"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 1000000 50 50 1" "tests/33" 33
echo "Generating test #34"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 1000000 1 1 1" "tests/34" 34
echo "Generating test #35"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 1000000 100 100 1" "tests/35" 35
echo "Generating test #36"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 0 1 2500000 200 199 1" "tests/36" 36
echo "Generating test #37"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 0 1 50000000 3 2 3" "tests/37" 37
echo "Generating test #38"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 0 1 750000000 2 1 1" "tests/38" 38
echo "Generating test #39"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 0 1 1000000000 10 9 1" "tests/39" 39
echo "Generating test #40"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 0 1 750000000 13 12 1" "tests/40" 40
echo "Generating test #41"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 0 1 750000000 2 1 1" "tests/41" 41
echo "Generating test #42"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 0 1 750000000 100 99 1" "tests/42" 42
echo "Generating test #43"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1000000000 1000 999 1" "tests/43" 43
echo "Generating test #44"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 10 3 4 5" "tests/44" 44
echo "Generating test #45"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 100 19 20 2" "tests/45" 45
echo "Generating test #46"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 500 1 2 4" "tests/46" 46
echo "Generating test #47"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 1000 50 51 1" "tests/47" 47
echo "Generating test #48"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 5000 98 99 3" "tests/48" 48
echo "Generating test #49"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 7500 50 51 1" "tests/49" 49
echo "Generating test #50"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 9000 99 100 3" "tests/50" 50
echo "Generating test #51"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 10000 1 2 1" "tests/51" 51
echo "Generating test #52"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 1000000 50 51 1" "tests/52" 52
echo "Generating test #53"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 1000000 1 2 1" "tests/53" 53
echo "Generating test #54"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 1000000 99 100 1" "tests/54" 54
echo "Generating test #55"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 0 1 2500000 199 200 1" "tests/55" 55
echo "Generating test #56"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 0 1 50000000 2 3 3" "tests/56" 56
echo "Generating test #57"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 0 1 750000000 1 2 1" "tests/57" 57
echo "Generating test #58"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 0 1 1000000000 9 10 1" "tests/58" 58
echo "Generating test #59"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 0 1 750000000 12 13 1" "tests/59" 59
echo "Generating test #60"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 0 1 750000000 1 2 1" "tests/60" 60
echo "Generating test #61"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 0 1 750000000 99 100 1" "tests/61" 61
echo "Generating test #62"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1000000000 999 1000 1" "tests/62" 62
echo "Generating test #63"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1 999 1000 1" "tests/63" 63
echo "Generating test #64"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 1 1 1" "tests/64" 64
echo "Generating test #65"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 1 2 1" "tests/65" 65
echo "Generating test #66"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 1 3 1" "tests/66" 66
echo "Generating test #67"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 1 4 1" "tests/67" 67
echo "Generating test #68"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 1 5 1" "tests/68" 68
echo "Generating test #69"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 2 1 1" "tests/69" 69
echo "Generating test #70"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 2 2 1" "tests/70" 70
echo "Generating test #71"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 2 3 1" "tests/71" 71
echo "Generating test #72"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 2 4 1" "tests/72" 72
echo "Generating test #73"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 2 5 1" "tests/73" 73
echo "Generating test #74"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 3 1 1" "tests/74" 74
echo "Generating test #75"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 3 2 1" "tests/75" 75
echo "Generating test #76"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 3 3 1" "tests/76" 76
echo "Generating test #77"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 3 4 1" "tests/77" 77
echo "Generating test #78"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 3 5 1" "tests/78" 78
echo "Generating test #79"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 4 1 1" "tests/79" 79
echo "Generating test #80"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 4 2 1" "tests/80" 80
echo "Generating test #81"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 4 3 1" "tests/81" 81
echo "Generating test #82"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 4 4 1" "tests/82" 82
echo "Generating test #83"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 4 5 1" "tests/83" 83
echo "Generating test #84"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 5 1 1" "tests/84" 84
echo "Generating test #85"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 5 2 1" "tests/85" 85
echo "Generating test #86"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 5 3 1" "tests/86" 86
echo "Generating test #87"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 5 4 1" "tests/87" 87
echo "Generating test #88"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 100 5 5 1" "tests/88" 88
echo "Generating test #89"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 1 1 10 1 5 5" "tests/89" 89
echo "Generating test #90"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 1 1 100 1 20 2" "tests/90" 90
echo "Generating test #91"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 1 1 100 1 50 1" "tests/91" 91
echo "Generating test #92"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 1 1 100 1 100 1" "tests/92" 92
echo "Generating test #93"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 1 1 100 1 200 3" "tests/93" 93
echo "Generating test #94"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 1 1 100 1 300 3" "tests/94" 94
echo "Generating test #95"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 1 1 100 1 400 3" "tests/95" 95
echo "Generating test #96"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 1 1 100 1 500 1" "tests/96" 96
echo "Generating test #97"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 1 1 100 1 600 1" "tests/97" 97
echo "Generating test #98"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 1 1 100 1 700 1" "tests/98" 98
echo "Generating test #99"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 1 1 100 1 800 1" "tests/99" 99
echo "Generating test #100"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 1 1 100 1 900 1" "tests/100" 100
echo "Generating test #101"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 100 1 1000 1" "tests/101" 101
echo "Generating test #102"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 1 1 1000 1" "tests/102" 102
echo "Generating test #103"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 1 1 10 5 1 5" "tests/103" 103
echo "Generating test #104"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 1 1 100 20 1 2" "tests/104" 104
echo "Generating test #105"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 1 1 100 50 1 1" "tests/105" 105
echo "Generating test #106"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 1 1 100 100 1 1" "tests/106" 106
echo "Generating test #107"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 1 1 100 200 1 3" "tests/107" 107
echo "Generating test #108"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 1 1 100 300 1 3" "tests/108" 108
echo "Generating test #109"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 1 1 100 400 1 3" "tests/109" 109
echo "Generating test #110"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 1 1 100 500 1 1" "tests/110" 110
echo "Generating test #111"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 1 1 100 600 1 1" "tests/111" 111
echo "Generating test #112"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 1 1 100 700 1 1" "tests/112" 112
echo "Generating test #113"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 1 1 100 800 1 1" "tests/113" 113
echo "Generating test #114"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 1 1 100 900 1 1" "tests/114" 114
echo "Generating test #115"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 100 1000 1 1" "tests/115" 115
echo "Generating test #116"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 1 1000 1 1" "tests/116" 116
echo "Generating test #117"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 1 1 10 1 5 3" "tests/117" 117
echo "Generating test #118"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 1 1 100 2 19 2" "tests/118" 118
echo "Generating test #119"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 1 1 100 4 45 1" "tests/119" 119
echo "Generating test #120"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 1 1 100 12 100 1" "tests/120" 120
echo "Generating test #121"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 1 1 100 120 155 3" "tests/121" 121
echo "Generating test #122"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 1 1 100 13 233 3" "tests/122" 122
echo "Generating test #123"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 1 1 100 133 400 3" "tests/123" 123
echo "Generating test #124"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 1 1 100 120 450 1" "tests/124" 124
echo "Generating test #125"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 1 1 100 2 600 1" "tests/125" 125
echo "Generating test #126"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 1 1 100 4 699 1" "tests/126" 126
echo "Generating test #127"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 1 1 100 5 799 1" "tests/127" 127
echo "Generating test #128"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 1 1 100 1 899 1" "tests/128" 128
echo "Generating test #129"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 100 2 999 1" "tests/129" 129
echo "Generating test #130"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 1 500 1000 1" "tests/130" 130
echo "Generating test #131"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 1 1 10 5 2 5" "tests/131" 131
echo "Generating test #132"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 1 1 100 19 2 2" "tests/132" 132
echo "Generating test #133"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 1 1 100 45 4 1" "tests/133" 133
echo "Generating test #134"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 1 1 100 100 12 2" "tests/134" 134
echo "Generating test #135"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 1 1 100 155 120 4" "tests/135" 135
echo "Generating test #136"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 1 1 100 233 13 4" "tests/136" 136
echo "Generating test #137"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 1 1 100 400 133 3" "tests/137" 137
echo "Generating test #138"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 1 1 100 450 120 2" "tests/138" 138
echo "Generating test #139"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 1 1 100 600 2 2" "tests/139" 139
echo "Generating test #140"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 1 1 100 699 4 2" "tests/140" 140
echo "Generating test #141"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 1 1 100 799 5 2" "tests/141" 141
echo "Generating test #142"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 1 1 100 899 1 2" "tests/142" 142
echo "Generating test #143"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 100 999 2 2" "tests/143" 143
echo "Generating test #144"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 1 1 1 1000 500 1" "tests/144" 144
echo "Generating test #145"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 10 1 5 2" "tests/145" 145
echo "Generating test #146"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 20 1 20 2" "tests/146" 146
echo "Generating test #147"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 0 1 30 1 50 1" "tests/147" 147
echo "Generating test #148"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 40 1 100 1" "tests/148" 148
echo "Generating test #149"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 0 1 50 1 200 3" "tests/149" 149
echo "Generating test #150"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 0 1 60 1 300 3" "tests/150" 150
echo "Generating test #151"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 0 1 70 1 400 3" "tests/151" 151
echo "Generating test #152"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 0 1 100 1 500 1" "tests/152" 152
echo "Generating test #153"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 0 1 100 1 600 1" "tests/153" 153
echo "Generating test #154"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 0 1 100 1 700 1" "tests/154" 154
echo "Generating test #155"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 0 1 100 1 800 1" "tests/155" 155
echo "Generating test #156"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 0 1 100 1 900 1" "tests/156" 156
echo "Generating test #157"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 100 1 1000 1" "tests/157" 157
echo "Generating test #158"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1 1 1000 2" "tests/158" 158
echo "Generating test #159"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 10 5 1 2" "tests/159" 159
echo "Generating test #160"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 20 20 1 3" "tests/160" 160
echo "Generating test #161"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 0 1 30 50 1 4" "tests/161" 161
echo "Generating test #162"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 40 100 1 1" "tests/162" 162
echo "Generating test #163"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 0 1 50 200 1 3" "tests/163" 163
echo "Generating test #164"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 0 1 60 300 1 3" "tests/164" 164
echo "Generating test #165"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 0 1 70 400 1 3" "tests/165" 165
echo "Generating test #166"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 0 1 100 500 1 1" "tests/166" 166
echo "Generating test #167"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 0 1 100 600 1 1" "tests/167" 167
echo "Generating test #168"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 0 1 100 700 1 1" "tests/168" 168
echo "Generating test #169"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 0 1 100 800 1 1" "tests/169" 169
echo "Generating test #170"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 0 1 100 900 1 1" "tests/170" 170
echo "Generating test #171"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 100 1000 1 1" "tests/171" 171
echo "Generating test #172"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1 1000 1 2" "tests/172" 172
echo "Generating test #173"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 10 1 5 3" "tests/173" 173
echo "Generating test #174"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 20 2 19 2" "tests/174" 174
echo "Generating test #175"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 0 1 50 4 45 1" "tests/175" 175
echo "Generating test #176"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 100 12 100 1" "tests/176" 176
echo "Generating test #177"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 0 1 100 120 155 3" "tests/177" 177
echo "Generating test #178"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 0 1 100 13 233 3" "tests/178" 178
echo "Generating test #179"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 0 1 100 133 400 3" "tests/179" 179
echo "Generating test #180"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 0 1 100 120 450 1" "tests/180" 180
echo "Generating test #181"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 0 1 100 2 600 1" "tests/181" 181
echo "Generating test #182"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 0 1 100 4 699 1" "tests/182" 182
echo "Generating test #183"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 0 1 100 5 799 1" "tests/183" 183
echo "Generating test #184"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 0 1 100 1 899 1" "tests/184" 184
echo "Generating test #185"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 100 2 999 1" "tests/185" 185
echo "Generating test #186"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1 500 1000 1" "tests/186" 186
echo "Generating test #187"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 10 5 2 5" "tests/187" 187
echo "Generating test #188"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 20 19 2 2" "tests/188" 188
echo "Generating test #189"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 0 1 50 45 4 1" "tests/189" 189
echo "Generating test #190"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 100 100 12 2" "tests/190" 190
echo "Generating test #191"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 0 1 100 155 120 4" "tests/191" 191
echo "Generating test #192"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 0 1 100 233 13 4" "tests/192" 192
echo "Generating test #193"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 0 1 100 400 133 3" "tests/193" 193
echo "Generating test #194"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 0 1 100 450 120 2" "tests/194" 194
echo "Generating test #195"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 0 1 100 600 2 2" "tests/195" 195
echo "Generating test #196"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 0 1 100 699 4 2" "tests/196" 196
echo "Generating test #197"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 0 1 100 799 5 2" "tests/197" 197
echo "Generating test #198"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 0 1 100 899 1 2" "tests/198" 198
echo "Generating test #199"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 100 999 2 2" "tests/199" 199
echo "Generating test #200"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1 1000 500 1" "tests/200" 200
echo "Generating test #201"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 10 1 5 5" "tests/201" 201
echo "Generating test #202"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 100 1 20 2" "tests/202" 202
echo "Generating test #203"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 0 1 100 1 50 1" "tests/203" 203
echo "Generating test #204"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 10000 1 100 1" "tests/204" 204
echo "Generating test #205"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 0 1 10000 1 200 3" "tests/205" 205
echo "Generating test #206"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 0 1 1000000000 1 300 3" "tests/206" 206
echo "Generating test #207"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 0 1 1000000000 1 400 3" "tests/207" 207
echo "Generating test #208"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 0 1 1000000000 1 500 1" "tests/208" 208
echo "Generating test #209"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 0 1 1000000000 1 600 1" "tests/209" 209
echo "Generating test #210"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 0 1 1000000000 1 700 1" "tests/210" 210
echo "Generating test #211"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 0 1 1000000000 1 800 1" "tests/211" 211
echo "Generating test #212"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 0 1 1000000000 1 900 1" "tests/212" 212
echo "Generating test #213"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1000000000 1 1000 1" "tests/213" 213
echo "Generating test #214"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1 1 1000 1" "tests/214" 214
echo "Generating test #215"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 10 5 1 5" "tests/215" 215
echo "Generating test #216"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 100 20 1 2" "tests/216" 216
echo "Generating test #217"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 0 1 100 50 1 1" "tests/217" 217
echo "Generating test #218"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 10000 100 1 1" "tests/218" 218
echo "Generating test #219"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 0 1 10000 200 1 3" "tests/219" 219
echo "Generating test #220"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 0 1 1000000000 300 1 3" "tests/220" 220
echo "Generating test #221"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 0 1 1000000000 400 1 3" "tests/221" 221
echo "Generating test #222"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 0 1 1000000000 500 1 1" "tests/222" 222
echo "Generating test #223"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 0 1 1000000000 600 1 1" "tests/223" 223
echo "Generating test #224"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 0 1 1000000000 700 1 1" "tests/224" 224
echo "Generating test #225"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 0 1 1000000000 800 1 1" "tests/225" 225
echo "Generating test #226"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 0 1 1000000000 900 1 1" "tests/226" 226
echo "Generating test #227"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1000000000 1000 1 1" "tests/227" 227
echo "Generating test #228"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1 1000 1 1" "tests/228" 228
echo "Generating test #229"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 10 1 5 31" "tests/229" 229
echo "Generating test #230"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 100 2 19 2" "tests/230" 230
echo "Generating test #231"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 0 1 100 4 45 1" "tests/231" 231
echo "Generating test #232"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 10000 12 100 1" "tests/232" 232
echo "Generating test #233"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 0 1 10000 120 155 3" "tests/233" 233
echo "Generating test #234"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 0 1 1000000000 13 233 3" "tests/234" 234
echo "Generating test #235"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 0 1 1000000000 133 400 3" "tests/235" 235
echo "Generating test #236"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 0 1 1000000000 120 450 1" "tests/236" 236
echo "Generating test #237"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 0 1 1000000000 2 600 1" "tests/237" 237
echo "Generating test #238"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 0 1 1000000000 4 699 1" "tests/238" 238
echo "Generating test #239"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 0 1 1000000000 5 799 1" "tests/239" 239
echo "Generating test #240"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 0 1 1000000000 1 899 1" "tests/240" 240
echo "Generating test #241"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1000000000 2 999 1" "tests/241" 241
echo "Generating test #242"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1 500 1000 2" "tests/242" 242
echo "Generating test #243"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 5 0 1 10 5 2 2" "tests/243" 243
echo "Generating test #244"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 20 0 1 100 19 2 2" "tests/244" 244
echo "Generating test #245"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 50 0 1 100 45 4 1" "tests/245" 245
echo "Generating test #246"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 100 0 1 10000 100 12 2" "tests/246" 246
echo "Generating test #247"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 200 0 1 10000 155 120 4" "tests/247" 247
echo "Generating test #248"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 300 0 1 1000000000 233 13 4" "tests/248" 248
echo "Generating test #249"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 400 0 1 1000000000 400 133 3" "tests/249" 249
echo "Generating test #250"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 500 0 1 1000000000 450 120 2" "tests/250" 250
echo "Generating test #251"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 600 0 1 1000000000 600 2 2" "tests/251" 251
echo "Generating test #252"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 700 0 1 1000000000 699 4 2" "tests/252" 252
echo "Generating test #253"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 800 0 1 1000000000 799 5 2" "tests/253" 253
echo "Generating test #254"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 900 0 1 1000000000 899 1 2" "tests/254" 254
echo "Generating test #255"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1000000000 999 2 2" "tests/255" 255
echo "Generating test #256"
scripts/gen-input-via-stdout.sh "wine files/gen.exe 1000 0 1 1 1000 500 2" "tests/256" 256
echo ""
echo "Generating answer for test #1"
scripts/gen-answer.sh tests/01 tests/01.a "tests" "0"
echo ""
echo "Generating answer for test #2"
scripts/gen-answer.sh tests/02 tests/02.a "tests" "0"
echo ""
echo "Generating answer for test #3"
scripts/gen-answer.sh tests/03 tests/03.a "tests" "0"
echo ""
echo "Generating answer for test #4"
scripts/gen-answer.sh tests/04 tests/04.a "tests" "1"
echo ""
echo "Generating answer for test #5"
scripts/gen-answer.sh tests/05 tests/05.a "tests" "1"
echo ""
echo "Generating answer for test #6"
scripts/gen-answer.sh tests/06 tests/06.a "tests" "1"
echo ""
echo "Generating answer for test #7"
scripts/gen-answer.sh tests/07 tests/07.a "tests" "1"
echo ""
echo "Generating answer for test #8"
scripts/gen-answer.sh tests/08 tests/08.a "tests" "1"
echo ""
echo "Generating answer for test #9"
scripts/gen-answer.sh tests/09 tests/09.a "tests" "1"
echo ""
echo "Generating answer for test #10"
scripts/gen-answer.sh tests/10 tests/10.a "tests" "1"
echo ""
echo "Generating answer for test #11"
scripts/gen-answer.sh tests/11 tests/11.a "tests" "1"
echo ""
echo "Generating answer for test #12"
scripts/gen-answer.sh tests/12 tests/12.a "tests" "1"
echo ""
echo "Generating answer for test #13"
scripts/gen-answer.sh tests/13 tests/13.a "tests" "1"
echo ""
echo "Generating answer for test #14"
scripts/gen-answer.sh tests/14 tests/14.a "tests" "1"
echo ""
echo "Generating answer for test #15"
scripts/gen-answer.sh tests/15 tests/15.a "tests" "1"
echo ""
echo "Generating answer for test #16"
scripts/gen-answer.sh tests/16 tests/16.a "tests" "2"
echo ""
echo "Generating answer for test #17"
scripts/gen-answer.sh tests/17 tests/17.a "tests" "2"
echo ""
echo "Generating answer for test #18"
scripts/gen-answer.sh tests/18 tests/18.a "tests" "2"
echo ""
echo "Generating answer for test #19"
scripts/gen-answer.sh tests/19 tests/19.a "tests" "2"
echo ""
echo "Generating answer for test #20"
scripts/gen-answer.sh tests/20 tests/20.a "tests" "2"
echo ""
echo "Generating answer for test #21"
scripts/gen-answer.sh tests/21 tests/21.a "tests" "2"
echo ""
echo "Generating answer for test #22"
scripts/gen-answer.sh tests/22 tests/22.a "tests" "2"
echo ""
echo "Generating answer for test #23"
scripts/gen-answer.sh tests/23 tests/23.a "tests" "2"
echo ""
echo "Generating answer for test #24"
scripts/gen-answer.sh tests/24 tests/24.a "tests" "2"
echo ""
echo "Generating answer for test #25"
scripts/gen-answer.sh tests/25 tests/25.a "tests" "3"
echo ""
echo "Generating answer for test #26"
scripts/gen-answer.sh tests/26 tests/26.a "tests" "3"
echo ""
echo "Generating answer for test #27"
scripts/gen-answer.sh tests/27 tests/27.a "tests" "3"
echo ""
echo "Generating answer for test #28"
scripts/gen-answer.sh tests/28 tests/28.a "tests" "3"
echo ""
echo "Generating answer for test #29"
scripts/gen-answer.sh tests/29 tests/29.a "tests" "3"
echo ""
echo "Generating answer for test #30"
scripts/gen-answer.sh tests/30 tests/30.a "tests" "3"
echo ""
echo "Generating answer for test #31"
scripts/gen-answer.sh tests/31 tests/31.a "tests" "3"
echo ""
echo "Generating answer for test #32"
scripts/gen-answer.sh tests/32 tests/32.a "tests" "3"
echo ""
echo "Generating answer for test #33"
scripts/gen-answer.sh tests/33 tests/33.a "tests" "4"
echo ""
echo "Generating answer for test #34"
scripts/gen-answer.sh tests/34 tests/34.a "tests" "4"
echo ""
echo "Generating answer for test #35"
scripts/gen-answer.sh tests/35 tests/35.a "tests" "4"
echo ""
echo "Generating answer for test #36"
scripts/gen-answer.sh tests/36 tests/36.a "tests" "4"
echo ""
echo "Generating answer for test #37"
scripts/gen-answer.sh tests/37 tests/37.a "tests" "4"
echo ""
echo "Generating answer for test #38"
scripts/gen-answer.sh tests/38 tests/38.a "tests" "4"
echo ""
echo "Generating answer for test #39"
scripts/gen-answer.sh tests/39 tests/39.a "tests" "4"
echo ""
echo "Generating answer for test #40"
scripts/gen-answer.sh tests/40 tests/40.a "tests" "4"
echo ""
echo "Generating answer for test #41"
scripts/gen-answer.sh tests/41 tests/41.a "tests" "4"
echo ""
echo "Generating answer for test #42"
scripts/gen-answer.sh tests/42 tests/42.a "tests" "4"
echo ""
echo "Generating answer for test #43"
scripts/gen-answer.sh tests/43 tests/43.a "tests" "4"
echo ""
echo "Generating answer for test #44"
scripts/gen-answer.sh tests/44 tests/44.a "tests" "5"
echo ""
echo "Generating answer for test #45"
scripts/gen-answer.sh tests/45 tests/45.a "tests" "5"
echo ""
echo "Generating answer for test #46"
scripts/gen-answer.sh tests/46 tests/46.a "tests" "5"
echo ""
echo "Generating answer for test #47"
scripts/gen-answer.sh tests/47 tests/47.a "tests" "5"
echo ""
echo "Generating answer for test #48"
scripts/gen-answer.sh tests/48 tests/48.a "tests" "5"
echo ""
echo "Generating answer for test #49"
scripts/gen-answer.sh tests/49 tests/49.a "tests" "5"
echo ""
echo "Generating answer for test #50"
scripts/gen-answer.sh tests/50 tests/50.a "tests" "5"
echo ""
echo "Generating answer for test #51"
scripts/gen-answer.sh tests/51 tests/51.a "tests" "5"
echo ""
echo "Generating answer for test #52"
scripts/gen-answer.sh tests/52 tests/52.a "tests" "6"
echo ""
echo "Generating answer for test #53"
scripts/gen-answer.sh tests/53 tests/53.a "tests" "6"
echo ""
echo "Generating answer for test #54"
scripts/gen-answer.sh tests/54 tests/54.a "tests" "6"
echo ""
echo "Generating answer for test #55"
scripts/gen-answer.sh tests/55 tests/55.a "tests" "6"
echo ""
echo "Generating answer for test #56"
scripts/gen-answer.sh tests/56 tests/56.a "tests" "6"
echo ""
echo "Generating answer for test #57"
scripts/gen-answer.sh tests/57 tests/57.a "tests" "6"
echo ""
echo "Generating answer for test #58"
scripts/gen-answer.sh tests/58 tests/58.a "tests" "6"
echo ""
echo "Generating answer for test #59"
scripts/gen-answer.sh tests/59 tests/59.a "tests" "6"
echo ""
echo "Generating answer for test #60"
scripts/gen-answer.sh tests/60 tests/60.a "tests" "6"
echo ""
echo "Generating answer for test #61"
scripts/gen-answer.sh tests/61 tests/61.a "tests" "6"
echo ""
echo "Generating answer for test #62"
scripts/gen-answer.sh tests/62 tests/62.a "tests" "6"
echo ""
echo "Generating answer for test #63"
scripts/gen-answer.sh tests/63 tests/63.a "tests" "6"
echo ""
echo "Generating answer for test #64"
scripts/gen-answer.sh tests/64 tests/64.a "tests" "7"
echo ""
echo "Generating answer for test #65"
scripts/gen-answer.sh tests/65 tests/65.a "tests" "7"
echo ""
echo "Generating answer for test #66"
scripts/gen-answer.sh tests/66 tests/66.a "tests" "7"
echo ""
echo "Generating answer for test #67"
scripts/gen-answer.sh tests/67 tests/67.a "tests" "7"
echo ""
echo "Generating answer for test #68"
scripts/gen-answer.sh tests/68 tests/68.a "tests" "7"
echo ""
echo "Generating answer for test #69"
scripts/gen-answer.sh tests/69 tests/69.a "tests" "7"
echo ""
echo "Generating answer for test #70"
scripts/gen-answer.sh tests/70 tests/70.a "tests" "7"
echo ""
echo "Generating answer for test #71"
scripts/gen-answer.sh tests/71 tests/71.a "tests" "7"
echo ""
echo "Generating answer for test #72"
scripts/gen-answer.sh tests/72 tests/72.a "tests" "7"
echo ""
echo "Generating answer for test #73"
scripts/gen-answer.sh tests/73 tests/73.a "tests" "7"
echo ""
echo "Generating answer for test #74"
scripts/gen-answer.sh tests/74 tests/74.a "tests" "7"
echo ""
echo "Generating answer for test #75"
scripts/gen-answer.sh tests/75 tests/75.a "tests" "7"
echo ""
echo "Generating answer for test #76"
scripts/gen-answer.sh tests/76 tests/76.a "tests" "7"
echo ""
echo "Generating answer for test #77"
scripts/gen-answer.sh tests/77 tests/77.a "tests" "7"
echo ""
echo "Generating answer for test #78"
scripts/gen-answer.sh tests/78 tests/78.a "tests" "7"
echo ""
echo "Generating answer for test #79"
scripts/gen-answer.sh tests/79 tests/79.a "tests" "7"
echo ""
echo "Generating answer for test #80"
scripts/gen-answer.sh tests/80 tests/80.a "tests" "7"
echo ""
echo "Generating answer for test #81"
scripts/gen-answer.sh tests/81 tests/81.a "tests" "7"
echo ""
echo "Generating answer for test #82"
scripts/gen-answer.sh tests/82 tests/82.a "tests" "7"
echo ""
echo "Generating answer for test #83"
scripts/gen-answer.sh tests/83 tests/83.a "tests" "7"
echo ""
echo "Generating answer for test #84"
scripts/gen-answer.sh tests/84 tests/84.a "tests" "7"
echo ""
echo "Generating answer for test #85"
scripts/gen-answer.sh tests/85 tests/85.a "tests" "7"
echo ""
echo "Generating answer for test #86"
scripts/gen-answer.sh tests/86 tests/86.a "tests" "7"
echo ""
echo "Generating answer for test #87"
scripts/gen-answer.sh tests/87 tests/87.a "tests" "7"
echo ""
echo "Generating answer for test #88"
scripts/gen-answer.sh tests/88 tests/88.a "tests" "7"
echo ""
echo "Generating answer for test #89"
scripts/gen-answer.sh tests/89 tests/89.a "tests" "7"
echo ""
echo "Generating answer for test #90"
scripts/gen-answer.sh tests/90 tests/90.a "tests" "8"
echo ""
echo "Generating answer for test #91"
scripts/gen-answer.sh tests/91 tests/91.a "tests" "8"
echo ""
echo "Generating answer for test #92"
scripts/gen-answer.sh tests/92 tests/92.a "tests" "8"
echo ""
echo "Generating answer for test #93"
scripts/gen-answer.sh tests/93 tests/93.a "tests" "8"
echo ""
echo "Generating answer for test #94"
scripts/gen-answer.sh tests/94 tests/94.a "tests" "8"
echo ""
echo "Generating answer for test #95"
scripts/gen-answer.sh tests/95 tests/95.a "tests" "8"
echo ""
echo "Generating answer for test #96"
scripts/gen-answer.sh tests/96 tests/96.a "tests" "8"
echo ""
echo "Generating answer for test #97"
scripts/gen-answer.sh tests/97 tests/97.a "tests" "8"
echo ""
echo "Generating answer for test #98"
scripts/gen-answer.sh tests/98 tests/98.a "tests" "8"
echo ""
echo "Generating answer for test #99"
scripts/gen-answer.sh tests/99 tests/99.a "tests" "8"
echo ""
echo "Generating answer for test #100"
scripts/gen-answer.sh tests/100 tests/100.a "tests" "8"
echo ""
echo "Generating answer for test #101"
scripts/gen-answer.sh tests/101 tests/101.a "tests" "8"
echo ""
echo "Generating answer for test #102"
scripts/gen-answer.sh tests/102 tests/102.a "tests" "8"
echo ""
echo "Generating answer for test #103"
scripts/gen-answer.sh tests/103 tests/103.a "tests" "9"
echo ""
echo "Generating answer for test #104"
scripts/gen-answer.sh tests/104 tests/104.a "tests" "9"
echo ""
echo "Generating answer for test #105"
scripts/gen-answer.sh tests/105 tests/105.a "tests" "9"
echo ""
echo "Generating answer for test #106"
scripts/gen-answer.sh tests/106 tests/106.a "tests" "9"
echo ""
echo "Generating answer for test #107"
scripts/gen-answer.sh tests/107 tests/107.a "tests" "9"
echo ""
echo "Generating answer for test #108"
scripts/gen-answer.sh tests/108 tests/108.a "tests" "9"
echo ""
echo "Generating answer for test #109"
scripts/gen-answer.sh tests/109 tests/109.a "tests" "9"
echo ""
echo "Generating answer for test #110"
scripts/gen-answer.sh tests/110 tests/110.a "tests" "9"
echo ""
echo "Generating answer for test #111"
scripts/gen-answer.sh tests/111 tests/111.a "tests" "9"
echo ""
echo "Generating answer for test #112"
scripts/gen-answer.sh tests/112 tests/112.a "tests" "9"
echo ""
echo "Generating answer for test #113"
scripts/gen-answer.sh tests/113 tests/113.a "tests" "9"
echo ""
echo "Generating answer for test #114"
scripts/gen-answer.sh tests/114 tests/114.a "tests" "9"
echo ""
echo "Generating answer for test #115"
scripts/gen-answer.sh tests/115 tests/115.a "tests" "9"
echo ""
echo "Generating answer for test #116"
scripts/gen-answer.sh tests/116 tests/116.a "tests" "9"
echo ""
echo "Generating answer for test #117"
scripts/gen-answer.sh tests/117 tests/117.a "tests" "10"
echo ""
echo "Generating answer for test #118"
scripts/gen-answer.sh tests/118 tests/118.a "tests" "10"
echo ""
echo "Generating answer for test #119"
scripts/gen-answer.sh tests/119 tests/119.a "tests" "10"
echo ""
echo "Generating answer for test #120"
scripts/gen-answer.sh tests/120 tests/120.a "tests" "10"
echo ""
echo "Generating answer for test #121"
scripts/gen-answer.sh tests/121 tests/121.a "tests" "10"
echo ""
echo "Generating answer for test #122"
scripts/gen-answer.sh tests/122 tests/122.a "tests" "10"
echo ""
echo "Generating answer for test #123"
scripts/gen-answer.sh tests/123 tests/123.a "tests" "10"
echo ""
echo "Generating answer for test #124"
scripts/gen-answer.sh tests/124 tests/124.a "tests" "10"
echo ""
echo "Generating answer for test #125"
scripts/gen-answer.sh tests/125 tests/125.a "tests" "10"
echo ""
echo "Generating answer for test #126"
scripts/gen-answer.sh tests/126 tests/126.a "tests" "10"
echo ""
echo "Generating answer for test #127"
scripts/gen-answer.sh tests/127 tests/127.a "tests" "10"
echo ""
echo "Generating answer for test #128"
scripts/gen-answer.sh tests/128 tests/128.a "tests" "10"
echo ""
echo "Generating answer for test #129"
scripts/gen-answer.sh tests/129 tests/129.a "tests" "10"
echo ""
echo "Generating answer for test #130"
scripts/gen-answer.sh tests/130 tests/130.a "tests" "10"
echo ""
echo "Generating answer for test #131"
scripts/gen-answer.sh tests/131 tests/131.a "tests" "11"
echo ""
echo "Generating answer for test #132"
scripts/gen-answer.sh tests/132 tests/132.a "tests" "11"
echo ""
echo "Generating answer for test #133"
scripts/gen-answer.sh tests/133 tests/133.a "tests" "11"
echo ""
echo "Generating answer for test #134"
scripts/gen-answer.sh tests/134 tests/134.a "tests" "11"
echo ""
echo "Generating answer for test #135"
scripts/gen-answer.sh tests/135 tests/135.a "tests" "11"
echo ""
echo "Generating answer for test #136"
scripts/gen-answer.sh tests/136 tests/136.a "tests" "11"
echo ""
echo "Generating answer for test #137"
scripts/gen-answer.sh tests/137 tests/137.a "tests" "11"
echo ""
echo "Generating answer for test #138"
scripts/gen-answer.sh tests/138 tests/138.a "tests" "11"
echo ""
echo "Generating answer for test #139"
scripts/gen-answer.sh tests/139 tests/139.a "tests" "11"
echo ""
echo "Generating answer for test #140"
scripts/gen-answer.sh tests/140 tests/140.a "tests" "11"
echo ""
echo "Generating answer for test #141"
scripts/gen-answer.sh tests/141 tests/141.a "tests" "11"
echo ""
echo "Generating answer for test #142"
scripts/gen-answer.sh tests/142 tests/142.a "tests" "11"
echo ""
echo "Generating answer for test #143"
scripts/gen-answer.sh tests/143 tests/143.a "tests" "11"
echo ""
echo "Generating answer for test #144"
scripts/gen-answer.sh tests/144 tests/144.a "tests" "11"
echo ""
echo "Generating answer for test #145"
scripts/gen-answer.sh tests/145 tests/145.a "tests" "12"
echo ""
echo "Generating answer for test #146"
scripts/gen-answer.sh tests/146 tests/146.a "tests" "12"
echo ""
echo "Generating answer for test #147"
scripts/gen-answer.sh tests/147 tests/147.a "tests" "12"
echo ""
echo "Generating answer for test #148"
scripts/gen-answer.sh tests/148 tests/148.a "tests" "12"
echo ""
echo "Generating answer for test #149"
scripts/gen-answer.sh tests/149 tests/149.a "tests" "12"
echo ""
echo "Generating answer for test #150"
scripts/gen-answer.sh tests/150 tests/150.a "tests" "12"
echo ""
echo "Generating answer for test #151"
scripts/gen-answer.sh tests/151 tests/151.a "tests" "12"
echo ""
echo "Generating answer for test #152"
scripts/gen-answer.sh tests/152 tests/152.a "tests" "12"
echo ""
echo "Generating answer for test #153"
scripts/gen-answer.sh tests/153 tests/153.a "tests" "12"
echo ""
echo "Generating answer for test #154"
scripts/gen-answer.sh tests/154 tests/154.a "tests" "12"
echo ""
echo "Generating answer for test #155"
scripts/gen-answer.sh tests/155 tests/155.a "tests" "12"
echo ""
echo "Generating answer for test #156"
scripts/gen-answer.sh tests/156 tests/156.a "tests" "12"
echo ""
echo "Generating answer for test #157"
scripts/gen-answer.sh tests/157 tests/157.a "tests" "12"
echo ""
echo "Generating answer for test #158"
scripts/gen-answer.sh tests/158 tests/158.a "tests" "12"
echo ""
echo "Generating answer for test #159"
scripts/gen-answer.sh tests/159 tests/159.a "tests" "13"
echo ""
echo "Generating answer for test #160"
scripts/gen-answer.sh tests/160 tests/160.a "tests" "13"
echo ""
echo "Generating answer for test #161"
scripts/gen-answer.sh tests/161 tests/161.a "tests" "13"
echo ""
echo "Generating answer for test #162"
scripts/gen-answer.sh tests/162 tests/162.a "tests" "13"
echo ""
echo "Generating answer for test #163"
scripts/gen-answer.sh tests/163 tests/163.a "tests" "13"
echo ""
echo "Generating answer for test #164"
scripts/gen-answer.sh tests/164 tests/164.a "tests" "13"
echo ""
echo "Generating answer for test #165"
scripts/gen-answer.sh tests/165 tests/165.a "tests" "13"
echo ""
echo "Generating answer for test #166"
scripts/gen-answer.sh tests/166 tests/166.a "tests" "13"
echo ""
echo "Generating answer for test #167"
scripts/gen-answer.sh tests/167 tests/167.a "tests" "13"
echo ""
echo "Generating answer for test #168"
scripts/gen-answer.sh tests/168 tests/168.a "tests" "13"
echo ""
echo "Generating answer for test #169"
scripts/gen-answer.sh tests/169 tests/169.a "tests" "13"
echo ""
echo "Generating answer for test #170"
scripts/gen-answer.sh tests/170 tests/170.a "tests" "13"
echo ""
echo "Generating answer for test #171"
scripts/gen-answer.sh tests/171 tests/171.a "tests" "13"
echo ""
echo "Generating answer for test #172"
scripts/gen-answer.sh tests/172 tests/172.a "tests" "13"
echo ""
echo "Generating answer for test #173"
scripts/gen-answer.sh tests/173 tests/173.a "tests" "14"
echo ""
echo "Generating answer for test #174"
scripts/gen-answer.sh tests/174 tests/174.a "tests" "14"
echo ""
echo "Generating answer for test #175"
scripts/gen-answer.sh tests/175 tests/175.a "tests" "14"
echo ""
echo "Generating answer for test #176"
scripts/gen-answer.sh tests/176 tests/176.a "tests" "14"
echo ""
echo "Generating answer for test #177"
scripts/gen-answer.sh tests/177 tests/177.a "tests" "14"
echo ""
echo "Generating answer for test #178"
scripts/gen-answer.sh tests/178 tests/178.a "tests" "14"
echo ""
echo "Generating answer for test #179"
scripts/gen-answer.sh tests/179 tests/179.a "tests" "14"
echo ""
echo "Generating answer for test #180"
scripts/gen-answer.sh tests/180 tests/180.a "tests" "14"
echo ""
echo "Generating answer for test #181"
scripts/gen-answer.sh tests/181 tests/181.a "tests" "14"
echo ""
echo "Generating answer for test #182"
scripts/gen-answer.sh tests/182 tests/182.a "tests" "14"
echo ""
echo "Generating answer for test #183"
scripts/gen-answer.sh tests/183 tests/183.a "tests" "14"
echo ""
echo "Generating answer for test #184"
scripts/gen-answer.sh tests/184 tests/184.a "tests" "14"
echo ""
echo "Generating answer for test #185"
scripts/gen-answer.sh tests/185 tests/185.a "tests" "14"
echo ""
echo "Generating answer for test #186"
scripts/gen-answer.sh tests/186 tests/186.a "tests" "14"
echo ""
echo "Generating answer for test #187"
scripts/gen-answer.sh tests/187 tests/187.a "tests" "15"
echo ""
echo "Generating answer for test #188"
scripts/gen-answer.sh tests/188 tests/188.a "tests" "15"
echo ""
echo "Generating answer for test #189"
scripts/gen-answer.sh tests/189 tests/189.a "tests" "15"
echo ""
echo "Generating answer for test #190"
scripts/gen-answer.sh tests/190 tests/190.a "tests" "15"
echo ""
echo "Generating answer for test #191"
scripts/gen-answer.sh tests/191 tests/191.a "tests" "15"
echo ""
echo "Generating answer for test #192"
scripts/gen-answer.sh tests/192 tests/192.a "tests" "15"
echo ""
echo "Generating answer for test #193"
scripts/gen-answer.sh tests/193 tests/193.a "tests" "15"
echo ""
echo "Generating answer for test #194"
scripts/gen-answer.sh tests/194 tests/194.a "tests" "15"
echo ""
echo "Generating answer for test #195"
scripts/gen-answer.sh tests/195 tests/195.a "tests" "15"
echo ""
echo "Generating answer for test #196"
scripts/gen-answer.sh tests/196 tests/196.a "tests" "15"
echo ""
echo "Generating answer for test #197"
scripts/gen-answer.sh tests/197 tests/197.a "tests" "15"
echo ""
echo "Generating answer for test #198"
scripts/gen-answer.sh tests/198 tests/198.a "tests" "15"
echo ""
echo "Generating answer for test #199"
scripts/gen-answer.sh tests/199 tests/199.a "tests" "15"
echo ""
echo "Generating answer for test #200"
scripts/gen-answer.sh tests/200 tests/200.a "tests" "15"
echo ""
echo "Generating answer for test #201"
scripts/gen-answer.sh tests/201 tests/201.a "tests" "16"
echo ""
echo "Generating answer for test #202"
scripts/gen-answer.sh tests/202 tests/202.a "tests" "16"
echo ""
echo "Generating answer for test #203"
scripts/gen-answer.sh tests/203 tests/203.a "tests" "16"
echo ""
echo "Generating answer for test #204"
scripts/gen-answer.sh tests/204 tests/204.a "tests" "16"
echo ""
echo "Generating answer for test #205"
scripts/gen-answer.sh tests/205 tests/205.a "tests" "16"
echo ""
echo "Generating answer for test #206"
scripts/gen-answer.sh tests/206 tests/206.a "tests" "16"
echo ""
echo "Generating answer for test #207"
scripts/gen-answer.sh tests/207 tests/207.a "tests" "16"
echo ""
echo "Generating answer for test #208"
scripts/gen-answer.sh tests/208 tests/208.a "tests" "16"
echo ""
echo "Generating answer for test #209"
scripts/gen-answer.sh tests/209 tests/209.a "tests" "16"
echo ""
echo "Generating answer for test #210"
scripts/gen-answer.sh tests/210 tests/210.a "tests" "16"
echo ""
echo "Generating answer for test #211"
scripts/gen-answer.sh tests/211 tests/211.a "tests" "16"
echo ""
echo "Generating answer for test #212"
scripts/gen-answer.sh tests/212 tests/212.a "tests" "16"
echo ""
echo "Generating answer for test #213"
scripts/gen-answer.sh tests/213 tests/213.a "tests" "16"
echo ""
echo "Generating answer for test #214"
scripts/gen-answer.sh tests/214 tests/214.a "tests" "16"
echo ""
echo "Generating answer for test #215"
scripts/gen-answer.sh tests/215 tests/215.a "tests" "17"
echo ""
echo "Generating answer for test #216"
scripts/gen-answer.sh tests/216 tests/216.a "tests" "17"
echo ""
echo "Generating answer for test #217"
scripts/gen-answer.sh tests/217 tests/217.a "tests" "17"
echo ""
echo "Generating answer for test #218"
scripts/gen-answer.sh tests/218 tests/218.a "tests" "17"
echo ""
echo "Generating answer for test #219"
scripts/gen-answer.sh tests/219 tests/219.a "tests" "17"
echo ""
echo "Generating answer for test #220"
scripts/gen-answer.sh tests/220 tests/220.a "tests" "17"
echo ""
echo "Generating answer for test #221"
scripts/gen-answer.sh tests/221 tests/221.a "tests" "17"
echo ""
echo "Generating answer for test #222"
scripts/gen-answer.sh tests/222 tests/222.a "tests" "17"
echo ""
echo "Generating answer for test #223"
scripts/gen-answer.sh tests/223 tests/223.a "tests" "17"
echo ""
echo "Generating answer for test #224"
scripts/gen-answer.sh tests/224 tests/224.a "tests" "17"
echo ""
echo "Generating answer for test #225"
scripts/gen-answer.sh tests/225 tests/225.a "tests" "17"
echo ""
echo "Generating answer for test #226"
scripts/gen-answer.sh tests/226 tests/226.a "tests" "17"
echo ""
echo "Generating answer for test #227"
scripts/gen-answer.sh tests/227 tests/227.a "tests" "17"
echo ""
echo "Generating answer for test #228"
scripts/gen-answer.sh tests/228 tests/228.a "tests" "17"
echo ""
echo "Generating answer for test #229"
scripts/gen-answer.sh tests/229 tests/229.a "tests" "18"
echo ""
echo "Generating answer for test #230"
scripts/gen-answer.sh tests/230 tests/230.a "tests" "18"
echo ""
echo "Generating answer for test #231"
scripts/gen-answer.sh tests/231 tests/231.a "tests" "18"
echo ""
echo "Generating answer for test #232"
scripts/gen-answer.sh tests/232 tests/232.a "tests" "18"
echo ""
echo "Generating answer for test #233"
scripts/gen-answer.sh tests/233 tests/233.a "tests" "18"
echo ""
echo "Generating answer for test #234"
scripts/gen-answer.sh tests/234 tests/234.a "tests" "18"
echo ""
echo "Generating answer for test #235"
scripts/gen-answer.sh tests/235 tests/235.a "tests" "18"
echo ""
echo "Generating answer for test #236"
scripts/gen-answer.sh tests/236 tests/236.a "tests" "18"
echo ""
echo "Generating answer for test #237"
scripts/gen-answer.sh tests/237 tests/237.a "tests" "18"
echo ""
echo "Generating answer for test #238"
scripts/gen-answer.sh tests/238 tests/238.a "tests" "18"
echo ""
echo "Generating answer for test #239"
scripts/gen-answer.sh tests/239 tests/239.a "tests" "18"
echo ""
echo "Generating answer for test #240"
scripts/gen-answer.sh tests/240 tests/240.a "tests" "18"
echo ""
echo "Generating answer for test #241"
scripts/gen-answer.sh tests/241 tests/241.a "tests" "18"
echo ""
echo "Generating answer for test #242"
scripts/gen-answer.sh tests/242 tests/242.a "tests" "18"
echo ""
echo "Generating answer for test #243"
scripts/gen-answer.sh tests/243 tests/243.a "tests" "19"
echo ""
echo "Generating answer for test #244"
scripts/gen-answer.sh tests/244 tests/244.a "tests" "19"
echo ""
echo "Generating answer for test #245"
scripts/gen-answer.sh tests/245 tests/245.a "tests" "19"
echo ""
echo "Generating answer for test #246"
scripts/gen-answer.sh tests/246 tests/246.a "tests" "19"
echo ""
echo "Generating answer for test #247"
scripts/gen-answer.sh tests/247 tests/247.a "tests" "19"
echo ""
echo "Generating answer for test #248"
scripts/gen-answer.sh tests/248 tests/248.a "tests" "19"
echo ""
echo "Generating answer for test #249"
scripts/gen-answer.sh tests/249 tests/249.a "tests" "19"
echo ""
echo "Generating answer for test #250"
scripts/gen-answer.sh tests/250 tests/250.a "tests" "19"
echo ""
echo "Generating answer for test #251"
scripts/gen-answer.sh tests/251 tests/251.a "tests" "19"
echo ""
echo "Generating answer for test #252"
scripts/gen-answer.sh tests/252 tests/252.a "tests" "19"
echo ""
echo "Generating answer for test #253"
scripts/gen-answer.sh tests/253 tests/253.a "tests" "19"
echo ""
echo "Generating answer for test #254"
scripts/gen-answer.sh tests/254 tests/254.a "tests" "19"
echo ""
echo "Generating answer for test #255"
scripts/gen-answer.sh tests/255 tests/255.a "tests" "19"
echo ""
echo "Generating answer for test #256"
scripts/gen-answer.sh tests/256 tests/256.a "tests" "19"
echo ""

