#include "testlib.h"
 
#include <iostream>
#include <algorithm>
#include <vector>
 
using namespace std;
 
/*
 [2]    1. Площі всіх відомих діляночок --- прості числа або одиниці. 
           Діляночка, площу якої треба обчислити, знаходиться на головній або побічній діагоналі.
 [6]    2. Площі всіх відомих діляночок --- прості числа або одиниці. 
           Діляночка, площу якої треба обчислити, знаходиться на перетині $i$-го стовпчика та $(i+1)$-го рядка.
        3. Діляночка, площу якої треба обчислити, знаходиться на головній або побічній діагоналі.
        4. Діляночка, площу якої треба обчислити, знаходиться на перетині $i$-го стовпчика та $(i+1)$-го рядка.
 [7]    5. Площі всіх відомих діляночок не перевищують 10. $n = 5$
 [5]    6. Площі всіх відомих діляночок --- прості числа або одиниці. $p=1$, $q=n$. 
 [5]    7. Площі всіх відомих діляночок --- прості числа або одиниці. $p=n$, $q=1$. 
 [8]    8. Площі всіх відомих діляночок --- прості числа або одиниці. $p < q$. 
 [8]    9. Площі всіх відомих діляночок --- прості числа або одиниці. $p > q$. 
 [7]   10. Площі всіх відомих діляночок не перевищують 100. $p=1$, $q=n$.
 [8]   11. Площі всіх відомих діляночок не перевищують 100. $p=n$, $q=1$.
 [8]   12. Площі всіх відомих діляночок не перевищують 100. $p < q$.
 [9]   13. Площі всіх відомих діляночок не перевищують 100. $p > q$.
 [4]   14. $p=1$, $q=n$
 [5]   15. $p=n$, $q=1$
 [7]   16. $p < q$
 [8]   17. $p > q$
*/

bool isprime(int x) {
  if (x == 1)
    return false;
  for (int d = 2; d * 1LL * d <= x; d++)
    if (x % d == 0)
      return false;
  return true;
}

int nextprime(int x, int upd) {
  while (!isprime(x))
    x += upd;
  return x;
}

int f(int L, int R, int p) {
    if (L == R) return L;
    int x = rnd.next(L, R);
  if (p == 0)
    return x;
  int one = rnd.next(10);
  if (one % 5 == 0)
    return 1;
  int res = nextprime(x, 1);
  if (res > R) {
      return nextprime(x, -1);
  }
  return res;
}

int main(int argc, char* argv[]) {
    registerGen(argc, argv, 1);
    int n = opt<int>(1); // кількість діляночок = n^2
    int prime = opt<int>(2); // 0 - d[i] довільні, 1 - d[i] - прості або 1
    int L = opt<int>(3); // d[i], d1[i] >= L
    int R = opt<int>(4); // d[i], d1[i] <= R
    int p = opt<int>(5); // p
    int q = opt<int>(6); // q
    int seed = opt<int>(7);
    cout << n << '\n';
    for (int i = 0; i < n - 1; i++)
      cout << f(L, R, prime) << " ";
    cout << f(L, R, prime) << endl;
    for (int i = 0; i < n - 2; i++)
      cout << f(L, R, prime) << " ";
    cout << f(L, R, prime) << endl;
    cout << p << " " << q << endl;
}
