#include "testlib.h"
#include <bits/stdc++.h>
 
using namespace std;

const int MAX_n = 1e3;
const int MAX_a = 1e9;

vector<int> e, d;
int n, a, p, q;


bool isPrime(int n) {
    for (int d = 2; d * 1LL * d <= n; d++)
        if (n % d == 0)
            return false;
    return true;
}

bool isPrimesV(vector<int> v) {
    for (size_t i = 0; i < v.size(); i++)
        if (!isPrime(v[i]))
            return false;
    return true;
}

bool checkrange(vector<int> v, int L, int R) {
    for (size_t i = 0; i < v.size(); i++)
        if (v[i] < L || v[i] > R)
            return false;
    return true;
}

void ensurePrimes() {
    ensuref(isPrimesV(e), "e is not prime");
    ensuref(isPrimesV(d), "d is not prime");
}

void ensureRange(int max_a){
    ensuref(checkrange(e, 1, max_a), "wrong range for e");
    ensuref(checkrange(d, 1, max_a), "wrong range for d");
}

void ensureMainDiag() {
    ensure(p - 1 == q || p == q);
}

void ensureSecDiag() {
    ensure(p + 1 == q);
}

void ensurepsmq() {
    ensure(p < q);
}

void ensurepbgq() {
    ensure(p > q);
}

void validate_group_1() {
    ensurePrimes();
    ensureRange(100);
    ensureMainDiag();
}


void validate_group_2() {
    ensurePrimes();
    ensureRange(100);
    ensureSecDiag();
}

void validate_group_3() {
    ensureRange(10000);
    ensureMainDiag();
}

void validate_group_4() {
    ensureMainDiag();
}

void validate_group_5() {
    ensureRange(10000);
    ensureSecDiag();
}

void validate_group_6() {
    ensureSecDiag();
}

void validate_group_7() {
    ensure(n == 5);
    ensureRange(100);
}

void ensure1n() {
    ensure(p == 1);
    ensure(q == n);
}

void ensuren1() {
    ensure(p == n);
    ensure(q == 1);
}

void validate_group_8() {
    ensurePrimes();
    ensureRange(100);
    ensure1n();
}

void validate_group_9() {
    ensurePrimes();
    ensureRange(100);
    ensuren1();
}

void validate_group_10() {
    ensurePrimes();
    ensureRange(100);
    ensurepsmq();
}

void validate_group_11() {
    ensurePrimes();
    ensureRange(100);
    ensurepbgq();
}

void validate_group_12() {
    ensureRange(100);
    ensure1n();
}

void validate_group_13() {
    ensureRange(100);
    ensuren1();
}

void validate_group_14() {
    ensureRange(100);
    ensurepsmq();
}

void validate_group_15() {
    ensureRange(100);
    ensurepbgq();
}

void validate_group_16() {
    ensure1n();
}

void validate_group_17() {
    ensuren1();
}

void validate_group_18() {
    ensurepsmq();
}

void validate_group_19() {
    ensurepbgq();
}

void validate_group_0() {
}


int main(int argc, char* argv[])
{
    registerValidation(argc, argv);
    e.clear();
    d.clear();
    int group = stoi(validator.group());
    n = inf.readInt(2, MAX_n, "n");
    
    inf.readEoln();
    for (int i = 0; i < n - 1; i++) {
        a = inf.readInt(1, MAX_a, "a");
        e.push_back(a);
        inf.readSpace();
    }
    a = inf.readInt(1, MAX_a, "a");
    e.push_back(a);
    inf.readEoln();
    for (int i = 0; i < n - 2; i++) {
        a = inf.readInt(1, MAX_a, "a");
        d.push_back(a);
        inf.readSpace();
    }
    a = inf.readInt(1, MAX_a, "a");
    d.push_back(a);
    inf.readEoln();
    p = inf.readInt(1, n, "p");
    inf.readSpace();
    q = inf.readInt(1, n, "q");
    inf.readEoln();
    inf.readEof();
    if (group == 0) validate_group_0();
    if (group == 1) validate_group_1();
    if (group == 2) validate_group_2();
    if (group == 3) validate_group_3();
    if (group == 4) validate_group_4();
    if (group == 5) validate_group_5();
    if (group == 6) validate_group_6();
    if (group == 7) validate_group_7();
    if (group == 8) validate_group_8();
    if (group == 9) validate_group_9();
    if (group == 10) validate_group_10();
    if (group == 11) validate_group_11();
    if (group == 12) validate_group_12();
    if (group == 13) validate_group_13();
    if (group == 14) validate_group_14();
    if (group == 15) validate_group_15();
    if (group == 16) validate_group_16();
    if (group == 17) validate_group_17();
    if (group == 18) validate_group_18();
    if (group == 19) validate_group_19();
}
