#include <iostream>
#include <vector>
#include <sstream>
#include <map>

using namespace std;

typedef long long LL;

map<LL, LL> Factorisation(LL x) {
  map<LL, LL> m;
  m.clear();
  LL d = 2;
  do {
    while (x % d == 0) {
      m[d] += 1;
      x /= d;
    }
    d++;
    if (d * 1LL * d > x && x != 1) {
      m[x] += 1;
      break;
    }
  } while (x != 1);
  return m;
}

map<LL, LL> mult(map<LL, LL> a, map<LL, LL> b) {
  for (auto x : b)
    a[x.first] += x.second;
  return a;
}

map<LL, LL> div(map<LL, LL> a, map<LL, LL> b) {
  for (auto x : b)
    a[x.first] -= x.second;
  return a;
}

vector<map<LL, LL> > e, v, w;
map<LL, LL> ans;

int main() {
  LL n, x;
  cin >> n;
  e.resize(n);
  for (LL i = 0; i < n; i++) {
    cin >> x;
    e[i] = Factorisation(x);
  }

  v.resize(n-1);
  w.resize(n-1);
  for (LL i = 0; i < n - 1; i++) {
    cin >> x;
    v[i] = Factorisation(x);
    w[i] = div(mult(e[i], e[i+1]), v[i]);
  }

  int p, q;
  cin >> p >> q;
  p--;  q--;
  if (p > q) swap(p, q), swap(v, w);

  ans.clear();
  for (int i = p; i <= q; i++)
    ans = mult(ans, e[i]);
  for (int i = p; i <= q-1; i++)
    ans = div(ans, v[i]);

  if (ans.empty()) 
    ans[1] = 1;
    
  bool print = true;
  for (auto x : ans)
    if (x.second) {
      cout << x.first << " " << x.second << endl;
      print = false;
    }

  if (print)
    cout << "1 1\n";
  return 0;
}
