#include "testlib.h"
#include <sstream>
#include <vector>
#include <algorithm>

using namespace std;

vector<int> m;
int M1, M2;

inline void readSpaces(InStream &in) {
    while(in.curChar() == ' ') {
        in.nextChar();
    }
}

void check(InStream &in) {
    set<int> s;
    vector<int> v, p;
    int V = 0, P = 0;
    string vasyl = in.readToken("Vasyl:", "vasyl");
    while (!in.eoln()) {
        readSpaces(in);
        int x = in.readInt(1, 5, "x");
        readSpaces(in);
        
        v.push_back(x);
        s.insert(x);
        V += m[x - 1];
    }
    string petro = in.readToken("Petro:", "petro");
    while (!in.eoln()) {
        readSpaces(in);
        int x = in.readInt(1, 5, "x");
        readSpaces(in);
        
        p.push_back(x);
        s.insert(x);
        P += m[x - 1];
    }
    if ((int) v.size() + (int) p.size() != 5) {
        in.quitf(_wa, "Wrong number of integers");
    }
    if ((int) s.size() != 5) {
        in.quitf(_wa, "Integers are not unique");
    }
    if (V > M1) {
        in.quitf(_wa, "Vasyl has too much %d", V);
    }
    if (P > M2) {
        in.quitf(_wa, "Petro has too much %d", P);
    }
}

int main(int argc, char * argv[])
{
    setName("UOI-III 2023. Checker for task B");

    registerTestlibCmd(argc, argv);

    // Read input
    m.resize(5);
    for (int i = 0; i < 5; i++)
      m[i] = inf.readLong();
    M1 = inf.readLong();
    M2 = inf.readLong();

    int n = 0;
    
    string ans_verdict = ans.readString();
    string ouf_verdict = ouf.readString();
    
    if (ans_verdict != ouf_verdict) {
        quitf(_wa, "Expected %s, found %s", ans_verdict.c_str(), ouf_verdict.c_str());
    }
    
    if (ans_verdict != "They need to work together!") {
        quitf(_ok, "Answer is %s", ouf_verdict.c_str());
    }
    check(ans);
    check(ouf);
    quitf(_ok, "Numbers are correct");

}
