#include "testlib.h"
 
#include <iostream>
#include <algorithm>
#include <vector>
 
using namespace std;
 
vector<int> v;

int main(int argc, char* argv[]) {
    registerGen(argc, argv, 1);
    int n = opt<int>(1);  
    int perm = opt<int>(2); // 1 - permutation 1..n
    int orderedFirst = opt<int>(3); // 0 - unordered, 1 - ordered
    int orderedOther = opt<int>(4); // 0 - unordered, 1 - ordered
    int l = opt<int>(5); 
    int r = opt<int>(6); 
    int seed = opt<int>(7);
    cout << n << '\n';
    v.resize(n);

    if (perm) {
      for (int i = 0; i < n; i++)
        v[i] = i + 1;
    } else {
      for (int i = 0; i < n; i++) 
        v[i] = rnd.next(l, r); 
    }
    

    if (orderedFirst)
      sort(v.begin(), v.end());
    else
      shuffle(v.begin(), v.end());
    for (size_t i = 0; i < v.size() - 1; i++)
      cout << v[i] << " ";
    cout << v[v.size()-1] << '\n';

    for (int step = 0; step < n-1; step++) {
      shuffle(v.begin(), v.end());
      v.pop_back();
      if (orderedOther)
        sort(v.begin(), v.end());
      for (size_t i = 0; i < v.size() - 1; i++)
        cout << v[i] << " ";
      cout << v[v.size()-1] << '\n';
    }  
}
