#include <bits/stdc++.h>

using namespace std;

constexpr int N = 200'000 + 11;
constexpr int MAX_A = (1 << 20);

int a[N];
int t[4*N];
int n,q;

int lp[MAX_A];
set<int> possibleAnswers;

void init(){
    possibleAnswers.insert(0);
    lp[1] = 1;
    for(int i = 2; i < MAX_A; i++){
        if(lp[i])
            continue;
        lp[i] = i;
        for(long long j = 1ll * i*i; j < MAX_A; j += i){
            if(lp[j] == 0)
                lp[j] = i;
        }
    }
    return;
}

int cnt[MAX_A];

void getDivs(int pos,int x,vector<pair<int,int>>& v,vector<int>& div){
    if(pos == v.size()){
        div.push_back(x);
        return;
    }
    for(int i = 0; i <= v[pos].second; i++){
        getDivs(pos+1,x,v,div);
        x *= v[pos].first;
    }
    return;
}

void getDivs(int x,vector<int>& div){
    if(x == 1){
        div.push_back(1);
        return;
    }
    vector<pair<int,int>> v;
    int pr = lp[x];
    int cnt = 0;
    while(x > 1){
        if(lp[x] == pr){
            cnt++;
            assert(lp[x] != 0);
            x /= lp[x];
            continue;
        }
        v.push_back(make_pair(pr,cnt));
        cnt = 0;
        pr = lp[x];
    }
    v.push_back(make_pair(pr,cnt));
    getDivs(0,1,v,div);
    return;
}

vector<int> divs[MAX_A];

void add(int x){
    if(x == 0)
        return;
    vector<int>& div = divs[x];
    if(div.empty())
        getDivs(x,div);
    for(auto& d : div){
        cnt[d]++;
        if(cnt[d] == 2){
            possibleAnswers.insert(d);
        }
    }
    return;
}

void del(int x){
    if(x == 0)
        return;
    vector<int>& div = divs[x];
    if(div.empty())
        getDivs(x,div);
    for(auto& d : div){
        cnt[d]--;
        if(cnt[d] == 1){
            possibleAnswers.erase(d);
        }
    }
    return;
}

int answer(){
    return *(--possibleAnswers.end());
}

void build(int v,int l,int r){
    if(l == r){
        t[v] = a[l];
        add(a[l]);
        return;
    }
    int m = (l+r)>>1;
    build(v<<1,l,m);
    build(v<<1|1,m+1,r);
    t[v] = (t[v<<1] | t[v<<1|1]);
    return;
}

void upd(int v,int l,int r,int tl,int tr,int x){
    if(l > r || tl > tr || (t[v] & x) == t[v])
        return;
    if(l == r){
        del(t[v]);
        t[v] &= x;
        add(t[v]);
        return;
    }
    int m = (l+r)>>1;
    upd(v<<1,l,m,tl,min(tr,m),x);
    upd(v<<1|1,m+1,r,max(tl,m+1),tr,x);
    t[v] = (t[v<<1] | t[v<<1|1]);
    return;
}

int main(){
    ios::sync_with_stdio(false);cin.tie(nullptr);cout.tie(nullptr);

    init();

    cin >> n >> q;

    for(int i = 1; i <= n; i++){
        cin >> a[i];
    }

    build(1,1,n);

    cout << answer() << "\n";

    for(int i = 1; i <= q; i++){
        int l,r,x;
        cin >> l >> r >> x;
        upd(1,1,n,l,r,x);
        cout << answer() << "\n";
    }

    return 0;
}
